#include "ProcessorDecoder64.hh"

void ProcessorDecoder64::initDecoder(ProcessorSimulator *s,
				ProcessorData *d,
				MemoryUnit *m)
{
  simulator = s;
  memory=m;
  data=d;
}

void ProcessorDecoder64::execute (Instruction i,
				  Operand *o, 
				  int n,
				  ProcessorData *data)
{
  char incr = 1;
  switch(getOp(i))
    {
    case jmp: 
      data->setRegister(0,data->getRegister(getReg1(i)));
      incr = 0;
      break;
    case jz:
      if(data->getFlags(zf))
	{
	  data->setRegister(0,data->getRegister(getReg1(i)));
	  incr = 0;
	}
	  break;
    case jnz:
      if(!data->getFlags(zf))
	{
	  data->setRegister(0,data->getRegister(getReg1(i)));
	  incr = 0;
	}
    case l64:
	  {
	    memory->Load(iadd+sizeof(Instruction), this,0);
	    // Warning should be done in another way
	    data->setRegister(getReg1(i), temp);
	    // the memory->get call put the result in temp
	    incr = 3;
	  }
    case l32:
      {
	RegType im32 = memory->getInstruction(iadd+sizeof(Instruction));
	data->setRegister(getReg1(i),im32);
	incr = 2;
      }
      break;
    case l16:
      data->setRegister(getReg1(i),getIm16(i));
      break;
    }

  if(incr) data->setRegister
	     (0,(data->getRegister(0)+incr*sizeof(Instruction)));
  
}

void ProcessorDecoder64::tick()
{
  Instruction i;
  Operand *op;
  
  iadd = int(data->getRegister(0));
  i = memory->getInstruction(iadd);

  simulator->getUnit(i)->execute(i, op, 0, data);

  if(getUnit(i)) data->setRegister(0,(data->getRegister(0)+
				      sizeof(Instruction)));
}
