#ifndef ProcessorData64__HH
#define ProcessorData64__HH

#include <stdio.h>

#include "ProcessorSimulator64.hh"
#include "ProcessorData.hh"

const int zf = 0;
const int cf = 1;

const int maxflags =  2;
const int maxregs  = 64;

class ProcessorData64: 
  public virtual ProcessorData
{
private:
  ProcessorSimulator *simulator;
  RegType regs[maxregs];
  bool flags[maxflags];
  
public:
  
  ProcessorData64(){}
  ~ProcessorData64(){}

  void setProcessorSimulator(ProcessorSimulator *s)
    { simulator = s; }
  
  void init();
  
  void setRegister(int i, RegType r);
  RegType getRegister(int i);
  
  void setFlags(int i, bool b);
  bool getFlags(int i);

  inline int reg(int i)
    {
      if ((i>=maxregs)||(i<0))
	{
	  printf("Tried to access invalid register\n");
	  return -1;
	}
      else return i;
    }

  inline int flag(int i)
    {
      if ((i>=maxflags)||(i<0))
	{ 
	  printf("Tried to access invalid flag\n");
	  return -1;
	}
      else return i;
    }
};

#endif
