#include "LogicUnit.hh"
#include "InstructionSet.hh"

void LogicUnit::execute(Instruction i, Operand *o, int n, ProcessorData *data)
{
  switch(getOp(i))
    {
    case not: data->setRegister(getReg1(i),~data->getRegister(getReg1(i)));
      break;
    case and: data->setRegister(getReg1(i),
				data->getRegister(getReg1(i))&&
				data->getRegister(getReg2(i)));
    break;
    case or:  data->setRegister(getReg1(i),
				data->getRegister(getReg1(i))||
				data->getRegister(getReg2(i)));
    break;
    case xor: data->setRegister(getReg1(i),
				data->getRegister(getReg1(i))^
				data->getRegister(getReg2(i)));
    break;
    }
}
