#include "fcpudefs.h"

unsigned char fcpu_mem_memory[ FCPU_MEM_MEMORY_SIZE ];

unsigned char fcpu_mem_get_byte( UL64 a )
{
    return fcpu_mem_memory[ a % FCPU_MEM_MEMORY_SIZE ];
}

void fcpu_mem_put_byte( UL64 a, unsigned char d )
{
    fcpu_mem_memory[ a % FCPU_MEM_MEMORY_SIZE ] = d;
}

UL64 fcpu_mem_get_n_bytes_le( UL64 a, UL64 n )
{
    UL64 d;
    UL64 i;

    d = 0;

    for( i = 0; i < n; i++ )
    {
        d <<= 8;
        d |=  fcpu_mem_get_byte( a + n - 1 - i );
    }

    return d;
}

UL64 fcpu_mem_get_n_bytes_be( UL64 a, UL64 n )
{
    UL64 d;
    UL64 i;

    d = 0;

    for( i = 0; i < n; i++ )
    {
        d <<= 8;
        d |=  fcpu_mem_get_byte( a + n - 1 - i );
    }

    return d;
}

void fcpu_mem_put_n_bytes_le( UL64 a, UL64 n, UL64 d )
{
    UL64 i;
    
    for( i = 0; i < n; i++ )
    {
        fcpu_mem_put_byte( a + i, (unsigned char)d );
        d >>= 8;
    }
}

void fcpu_mem_put_n_bytes_be( UL64 a, UL64 n, UL64 d )
{
    UL64 i;
    
    for( i = 0; i < n; i++ )
    {
        fcpu_mem_put_byte( a + n - 1 - i, (unsigned char)d );
        d >>= 8;
    }
}

