/*
<HTML><TITLE>Whygee's dirty Xlib'ed interface</TITLE><BODY BGCOLOR="#FFFFFF" FGCOLOR="#000000">
<PRE>

 (C) mars 2000 by Yann Guidon, placed under GPL

Uses <A HREF="ygtk.c">ygtk.c</A>, includes <A HREF="view1.c">view1.c</A>, Xlib, events, etc...

One day, it will import and export VHDL, PostScript, HTML, C, Pascal, ADA,
and assembly langage from any CPU etc...

 */

/* home-brewed minimalistic X toolkit */
#include "ygtk.c"
/* for the keys */
#include <X11/keysym.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>

void error(int n, char *s); /* it is defined once exit_and_save_config is defined too */
#include "memory.c"
#include "nodes.c"

block_header *ll_warning=NULL; /* linked list root for the warning messages */
block_header *ll_filelist=NULL; /* linked list root for the file names (during brwosing) */
block_header *ll_string=NULL; /* linked list root for the strings (FLEX tokens) */


#include "flex_gnl.c"

/* number of function buttons */
#define nbottbutt 10
/* minimal width or height of a subwindow */
#define WINMINSIZE 30
/* minimal size of the main window */
#define min_xsize 300
#define min_ysize 200

/* X11 stuffs */

/* main window */

int i,j,k,l,m, /* some temporary variables */
 alt_key=0, /* 1 if at least one ALT key is pressed */
 resize=1, /* triggers the recomputation of all coordinates, and display */
 main_xsize, /* size of the main window */
 main_ysize,
 main_xpos, /* position of the main window */
 main_ypos,
 main_xsize2,  /* temporary size of the main window */
 main_ysize2,
 bitdepth,
 movestep=100, /* keyborad scrolling unit */ 
 hwork, /* height of the working window */
 wwork,/* width of the working window */
 xright,/* x coord of the right windows (clip,view,tool) */
 lright, /* actual width of the right windows */
 hclip, /* height of the clipboard window */
 htoolbar, /* height of the toolbar window */
 hview, /* height of the quickview window */
 htools, /* height of the tool window */
 hbottom,  /* height of the bottom bar */
 ybottom_button, /* y start of the (function) bottom windows */
 hbottom_button, /* height thereof */
 wbottbutt, /* width of the function buttons */
 hmenu, /* height of the menu buttons */
 menuheight, /* height of the menu bar */
 right_window_width=70, /* width of the right window */
 top_height=40,
 moving_button1=0, /* flag saying that we're moving the vertical bar */
 vmoving_button=0,
 /* bit 0: vmoving1 has changed,
    bit 1: vmoving2 has changed,
    bit 3: v1 is on focus if 1, v2 otherwise
    bit 4: moving one vertical bar,
    bit 5: vmoving1 has changed (sticky),
    bit 6: vmoving2 has changed (sticky) */
 hmoving1,/* height of the vertical moving bar */
 vmoving1=50, /* Y of the high horizontal bar */
 vmoving2=100, /* Y of the second (low) horizontal bar */
 xclick, /* coordinates of the point where we have clicked, */
 yclick, /* this makes the interface run more smoothly for the user */
 current_menu=0, /* current menu item that is being pressed */
 current_menu_line,
 current_menu_width,
 current_menu_height,
 buttonspressed=0;


#define nb_but_menu 6
char *but_menu_txt[nb_but_menu]={
 "Quit",
 "Files",
 "Sheets",
 "Configure",
 "Tools", 
 "Help",
};

int menu_widths[nb_but_menu];

char *functiontexts[]={
  "Unselect",
  "Save",
  "Load",
  "Copy",
  "Paste",
  "Del",
  "Move",
  "Undo",
  "Redo",
  "Viewsel"
};

int file_is_modified=0;

/* if file is modified : */
char *menufiles1[]={
  "Save",
  "Save as",
  "Close",
  NULL
};

char *menufiles2[]={
  "Load",
  NULL
};

char *menuvoid[]={
  "(Void)",
  NULL
};

char **ptr_menufiles[nb_but_menu]={
  NULL,
  menufiles2,
  menuvoid,
  menuvoid,
  menuvoid,
  menuvoid
};

void callback_load();

void (*fa1[3])(void)={callback_load, NULL,NULL};

void (**func_array[nb_but_menu])(void)={
  NULL,
  fa1,
  NULL,
  NULL,
  NULL,
  NULL
};


/* window hierarchy : */
Window
 win_main,
  win_menu,
   button_menu[nb_but_menu],
  win_work,
  win_right,
   win_clipboard,
   win_toolbar,
   win_quickview,
  win_bottom,
   win_message,
   win_status,
   win_bottom_button[nbottbutt],
 button_h_move1,
 button_v_move1,
 button_v_move2,
 win_popup
;

char functext[nbottbutt][3]; /* function key name */
int functextwidth[nbottbutt]; /* width (pixel) thereof */
int functextlength[nbottbutt]; /* length thereof */

XSegment bottom_segments1[4],bottom_segments2[4], /* segments displayed on the bottom bar*/
  bottom_segments3[2*nbottbutt],bottom_segments4[2*nbottbutt];
XSegment menu_segments1[nb_but_menu*2],
  menu_segments2[nb_but_menu*2]; /* segments for the menu bar (underlines the buttons) */
GC gc_main,gc_menu, gc1,gc2,gcbottbutt, gcwork,/* some graphic contexts... */
 gcgrey1,gcgrey2,gcgrey3,gcgrey4,gcgrey5,gcgrey6,gcgrey7;
Pixmap pixmap;
#define grey_width 8
#define grey_height 4
static char background_tile[grey_height]= { 0x00, 0x00, 0x22, 0x44 };
XEvent event;
/* key code conversion */
KeySym keysym;
char car;

/* for the message window : */
int msglength=54;
char GNLMessage[]="GNL is NOT a Langage... (C) march 2000 by Yann Guidon";
char *bottom_message=GNLMessage;

/* to save and restore the window position and size */
FILE *geom_file;
char geom_file_name[]=".gnl_geometry";

/* for the unuseful XGetGeometry results*/
int dumb;
Window wdumb;

void change_message(char *c){
  bottom_message=c;
  msglength=strlen(c);
  XClearWindow(dpy,win_message);
  XDrawImageString(dpy,win_message,gc2,4,font->ascent+2,c,msglength);
}


#include "view1.c"


void callback_load(){
  XBell(dpy,1);
}

void resize_clipboard(void) {
  XMoveResizeWindow(dpy,win_clipboard,xright,menuheight,lright,hclip);
}

void resize_toolbar(void) {
  XMoveResizeWindow(dpy,win_toolbar,xright,menuheight+vmoving1+10,lright,htoolbar);
}

void resize_bottom_bar(void) {
  int l,k,j,i=(main_xsize-right_window_width)-8;
  bottom_segments1[0].x1=bottom_segments1[2].x2=bottom_segments1[3].x1=bottom_segments1[3].x2=5;
  bottom_segments1[0].y1=bottom_segments1[0].y2=bottom_segments1[1].y1=bottom_segments1[3].y2=7;     
  bottom_segments1[0].x2=bottom_segments1[1].x1=bottom_segments1[1].x2=bottom_segments1[2].x1=5+i+1;  
  bottom_segments1[1].y2=bottom_segments1[2].y1=bottom_segments1[2].y2=bottom_segments1[3].y1=7+hmenu+1;
  bottom_segments2[0].x1=bottom_segments2[2].x2=bottom_segments2[3].x1=bottom_segments2[3].x2=4;
  bottom_segments2[0].y1=bottom_segments2[0].y2=bottom_segments2[1].y1=bottom_segments2[3].y2=6;     
  bottom_segments2[0].x2=bottom_segments2[1].x1=bottom_segments2[1].x2=bottom_segments2[2].x1=4+i+2+1;  
  bottom_segments2[1].y2=bottom_segments2[2].y1=bottom_segments2[2].y2=bottom_segments2[3].y1=6+hmenu+2+1;

  XMoveResizeWindow(dpy,win_bottom,0,main_ysize-hbottom,main_xsize-right_window_width,hbottom);
  XMoveResizeWindow(dpy,win_message,6,8,(main_xsize-right_window_width)-8,hmenu);

  j=3+hbottom_button+3;
  wbottbutt=(main_xsize-right_window_width-j-(4*nbottbutt));
  if (wbottbutt>(nbottbutt*5)){
    wbottbutt/=nbottbutt;
    k=0; l=1;
    for (i=0;i< nbottbutt;i++) {
      bottom_segments3[k].x1=bottom_segments3[k].x2=j++;
      bottom_segments4[l].x1=bottom_segments4[l].x2=j++;
      bottom_segments4[k].x1=bottom_segments4[k].x2=j++;
      bottom_segments3[l].x1=bottom_segments3[l].x2=j++;
      bottom_segments3[k].y1=bottom_segments3[l].y1=ybottom_button-2;
      bottom_segments4[l].y1=bottom_segments4[k].y1=ybottom_button-3;
      bottom_segments3[k].y2=bottom_segments3[l].y2=
	bottom_segments4[l].y2=bottom_segments4[k].y2=hbottom;
      k+=2;
      l+=2;
      XMoveResizeWindow(dpy,win_bottom_button[i],j,ybottom_button,wbottbutt,hbottom_button);
      j+=wbottbutt;
    }
  }
}

void display_v_moving_button (int moving,Window win) {
  int h=right_window_width-10;
  if (moving) {
    XDrawLine(dpy,win,gcgrey2,2,0,h,0);
    XDrawLine(dpy,win,gcgrey4,4,1,h,1);
    XDrawLine(dpy,win,gcgrey5,6,2,h,2);
    XDrawLine(dpy,win,gcgrey6,8,3,h,3);
    XDrawLine(dpy,win,gcgrey7,10,4,h,4);
    XDrawLine(dpy,win,gcgrey7,10,5,h,5);
    XDrawLine(dpy,win,gcgrey6,8,6,h,6);
    XDrawLine(dpy,win,gcgrey5,6,7,h,7);
    XDrawLine(dpy,win,gcgrey4,4,8,h,8);
    XDrawLine(dpy,win,gcgrey2,2,9,h,9);
  } else {
    XDrawLine(dpy,win,gcgrey2,2,0,h,0);
    XDrawLine(dpy,win,gcgrey3,4,1,h,1);
    XDrawLine(dpy,win,gcgrey3,6,2,h,2);
    XDrawLine(dpy,win,gcgrey4,8,3,h,3);
    XDrawLine(dpy,win,gcgrey5,10,4,h,4);
    XDrawLine(dpy,win,gcgrey5,10,5,h,5);
    XDrawLine(dpy,win,gcgrey4,8,6,h,6);
    XDrawLine(dpy,win,gcgrey3,6,7,h,7);
    XDrawLine(dpy,win,gcgrey3,4,8,h,8);
    XDrawLine(dpy,win,gcgrey2,2,9,h,9);
  }
}

void resize_v_button(int redisplay_other_windows){
  int i,j;

  /* problem between v1 and v2 */
  i=vmoving2-WINMINSIZE;
  if (vmoving1>i) {
    /* who pushes who ? */
    if (vmoving_button&8) { /* v1 in focus */
      vmoving_button|=2+32;
      vmoving2=vmoving1+WINMINSIZE;
    }
    else {
      vmoving_button|=1+16;
      vmoving1=i;
    }
  }

  /* lower bound for v2 */
  if (vmoving2 < WINMINSIZE*2) {
  /* push v1 */
    vmoving_button|=1+2+16+32;
    vmoving1=WINMINSIZE; 
    vmoving2=WINMINSIZE*2;
  } else {
    /* lower bound for v1 */
    if (vmoving1 < WINMINSIZE) {
      vmoving_button|=1+16;
      vmoving1=WINMINSIZE; 
    }
  }

  /* upper bound for v1 */
  i=(main_ysize-menuheight)-(WINMINSIZE*2);
  j=(main_ysize-menuheight)-WINMINSIZE;
  if (vmoving1 >i) {
  /* push v2 */
    vmoving_button|=1+2+16+32;
    vmoving1=i; 
    vmoving2=j; 
  } else {
    /* upper bound for v2 */
    if (vmoving2 >j) {
      vmoving_button|=2+32;
      vmoving2=j; 
    }
  }

  if (vmoving_button&1)
    XMoveResizeWindow(dpy,button_v_move1,main_xsize-right_window_width+10,menuheight+vmoving1,right_window_width-10,10);
  if (vmoving_button&2)
    XMoveResizeWindow(dpy,button_v_move2,main_xsize-right_window_width+10,menuheight+vmoving2,right_window_width-10,10);
  vmoving_button&= ~3;

  if (redisplay_other_windows) {
    if (vmoving_button&16) {
      hclip=vmoving1;
      resize_clipboard();
    }
    if (vmoving_button&48) { /* at least v1 or v2 has changed */
      htoolbar=vmoving2-vmoving1-10;
      resize_toolbar();
    }
    if (vmoving_button&32) {
      hview=main_ysize-menuheight-vmoving2-10;
      resize_view();
    }
   
    vmoving_button=0;
  }
}


void display_moving_button1 (int moving) {
  int h=main_ysize-menuheight;
  if (moving) {
    XDrawLine(dpy,button_h_move1,gcgrey2,0,2,0,h-hbottom+1);
    XDrawLine(dpy,button_h_move1,gcgrey4,1,4,1,h-hbottom+3);
    XDrawLine(dpy,button_h_move1,gcgrey5,2,6,2,h);
    XDrawLine(dpy,button_h_move1,gcgrey6,3,8,3,h);
    XDrawLine(dpy,button_h_move1,gcgrey7,4,10,4,h);
    XDrawLine(dpy,button_h_move1,gcgrey7,5,10,5,h);
    XDrawLine(dpy,button_h_move1,gcgrey6,6,8,6,h);
    XDrawLine(dpy,button_h_move1,gcgrey5,7,6,7,h);
    XDrawLine(dpy,button_h_move1,gcgrey4,8,4,8,h);
    XDrawLine(dpy,button_h_move1,gcgrey2,9,2,9,h);
  } else {
    XDrawLine(dpy,button_h_move1,gcgrey2,0,2,0,h-hbottom);
    XDrawLine(dpy,button_h_move1,gcgrey3,1,4,1,h-hbottom+1);
    XDrawLine(dpy,button_h_move1,gcgrey3,2,6,2,h-hbottom+1);
    XDrawLine(dpy,button_h_move1,gcgrey4,3,8,3,h-hbottom+2);
    XDrawLine(dpy,button_h_move1,gcgrey5,4,10,4,h);
    XDrawLine(dpy,button_h_move1,gcgrey5,5,10,5,h);
    XDrawLine(dpy,button_h_move1,gcgrey4,6,8,6,h);
    XDrawLine(dpy,button_h_move1,gcgrey3,7,6,7,h);
    XDrawLine(dpy,button_h_move1,gcgrey3,8,4,8,h);
    XDrawLine(dpy,button_h_move1,gcgrey2,9,2,9,h);
  }
}

void resize_move_button1(int new_width, int redisplay_other_windows){
  if (new_width < WINMINSIZE) {
    right_window_width=WINMINSIZE;
  } else {
    if (main_xsize-new_width < WINMINSIZE) {
      right_window_width=main_xsize-WINMINSIZE;
    } else {
      right_window_width=new_width;
    }
  }
  xright=main_xsize-right_window_width+10;
  lright=right_window_width-10;

  XMoveResizeWindow(dpy,button_h_move1,main_xsize-right_window_width,menuheight,10,hmoving1);
  if (redisplay_other_windows) {
    vmoving_button=1+2+16+32; /* forces redisplay */
    resize_v_button(1);
    resize_bottom_bar();
    resize_work();
  }
}

int read_int(void){
  int value=0;
  int c=fgetc(geom_file);
  /* remove spaces : */
  while ((c!=EOF)&&((c<'0')||(c>'9')))
    c=fgetc(geom_file);
  if (c==EOF)
    return 0;
  /* read decimal number without much overflow checkings... */
  while ((c!=EOF)&&((c>='0')&&(c<='9'))) {
    value=(value*10)+(c-'0');
    c=fgetc(geom_file);
  }
  ungetc(c,geom_file);
  return value;
}

void exit_and_save_config(int exit_code){
  /* collect here the X geometry of the window and save it to a file */
  if (display_is_open) {
    geom_file=fopen(geom_file_name,"wb");
    if ((geom_file!=NULL)&&(resize==0)) {
      XGetGeometry(dpy,win_main,&wdumb,&main_xpos,&main_ypos,&main_xsize,&main_ysize,&dumb,&dumb);
      fprintf(geom_file,"%d %d %d %d %d %d %d\n",main_xsize,main_ysize,main_xpos,main_ypos,right_window_width,vmoving1,vmoving2);
      fclose(geom_file);
    }
    close_window(&win_main);
    exitX();
  }
  exit(exit_code);
}

/* fatal signals handler : */
void sighandler_general(int signum){
  fprintf(stderr,"\nexit on signal %d\n",signum);
  exit_and_save_config(signum);
}

void error(int n, char *s) {
  fprintf(stderr,s);
  exit_and_save_config(n);
}

int main(int argc, char **argv)
{
  int scan_return=0;

  fprintf(stderr,"setting up signal handlers");
  /* signals are caught to prevent data loss... */
  signal(SIGSEGV, sighandler_general);  /* "count=*(int *)NULL;" */
  signal(SIGTERM, sighandler_general);  /* Ctrl+C */
  signal(SIGINT, sighandler_general);
  signal(SIGBUS, sighandler_general);
  signal(SIGHUP, sighandler_general);
  /* not all signals are handled yet. */

 /* signal(SIGALRM, sig_handler_ALRM);
  setitimer(ITIMER_REAL,&mytimer_RT,NULL);  for autosave etc, later...  */

  if (argc > 1) { /* skip over program name */
    fprintf(stderr,"\x0Dscanning GNL file %s    ",argv[1]);
    scan_return=scan_GNL(argv[1]);
    if (scan_return) {
      string_cell * p=first_warning;
      /* dump of the error messages : */
      putchar('\n');
      while (p!=NULL) {
	fprintf(stderr,"%s\n",((char*)p)+sizeof(string_cell));
	p=p->next;
      }
    } 
  }

  /* X11 */
  fprintf(stderr,"\x0Dsetting up X            ");
  init_X();
  XGetGeometry(dpy,RootWindow(dpy,DefaultScreen(dpy)),
    &wdumb,&dumb,&dumb,&main_xsize,&main_ysize,&dumb,&bitdepth);
  main_xpos=50;
  main_ypos=50;
  main_xsize=main_xsize-100;
  main_ysize=main_ysize-100;

  /* read the init file here, remember the window positions... if they are valid !*/
  geom_file=fopen(geom_file_name,"rb");
  if (geom_file!=NULL) {
    fprintf(stderr,"\x0Dreading geometry file            ");
    i=read_int();
    if ((i>min_xsize)&&(i<=main_xsize+100)) {
      main_xsize=i;
      i=read_int();
      if ((i>min_ysize)&&(i<=main_ysize+100)) {
	main_ysize=i;
	i=read_int();
	if (i<=(main_xsize+100)) {
	  main_xpos=i;
	  i=read_int();
	  if (i<=(main_ysize+100)) {
	    main_ypos=i;
	    i=read_int();
	    if ((i>WINMINSIZE)&&(i<=(main_xsize-WINMINSIZE))) {
	      right_window_width=i;
	      i=read_int();
	      if ((i>WINMINSIZE)&&(i<=(main_ysize-(2*WINMINSIZE)))) {
		vmoving1=i;
		i=read_int();
		if ((i>WINMINSIZE*2)&&(i<=(main_ysize-WINMINSIZE))) {
		  vmoving2=i;
		  fprintf(stderr,"\x0D.gnl_geometry read.            ");
		}
	      }
	    }
	  }
	}
      }
    }
  }

  fprintf(stderr,"\x0DOpening the windows etc            ");

  /* create all the windows : */
  open_window(&win_main,main_xpos,main_ypos,main_xsize,main_ysize,min_xsize,min_ysize,&gc_main,dim_grey,light_grey,"GNL",SHOWN);

  xgcv.foreground = doDefineColor (light_grey);
  gcgrey1 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey);
  gcgrey2 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey55);
  gcgrey3 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey40);
  gcgrey4 = XCreateGC (dpy, win_main, GCForeground , &xgcv);

  xgcv.foreground = doDefineColor (grey34);
  gcgrey5 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.background = xgcv.foreground;

  xgcv.foreground = doDefineColor (grey25);
  gcgrey6 = XCreateGC (dpy, win_main, GCForeground , &xgcv);
  xgcv.foreground = doDefineColor (grey18);
  gcgrey7 = XCreateGC (dpy, win_main, GCForeground , &xgcv);

  xgcv.foreground = doDefineColor (black);
  /*  xgcv.background = doDefineColor (grey34); */
  gcbottbutt = XCreateGC (dpy, win_main, GCForeground|GCBackground|GCFont , &xgcv);

  xgcv.background = doDefineColor (light_grey);
  gc2 = XCreateGC (dpy, win_main,GCForeground | GCBackground | GCFont
           | GCLineWidth | GCLineStyle, &xgcv);

  hmenu = font->ascent + font->descent + 3;
  menuheight = 4 + hmenu+ 10 ; 
  hmoving1 = main_ysize-menuheight;

  /* top bar : */
  open_daughter_window(&win_menu, win_main, 0,0, main_xsize, menuheight, &gc_menu, dim_grey,grey34,0);
  j=4; k=0;
  for (i=0;i< nb_but_menu;i++) {
    l=7+XTextWidth(font,but_menu_txt[i],strlen(but_menu_txt[i]));
    menu_widths[i]=l;
    open_daughter_window (&button_menu[i], win_main, j, 4,l, hmenu, NULL, black, light_grey, 0);

    /* underlines the buttons : */
    menu_segments1[k+0].x1=menu_segments2[k+0].x1=j;
    j+=l;
    menu_segments1[k+0].x2=menu_segments1[k+1].x1=menu_segments1[k+1].x2=j;
    menu_segments2[k+0].x2=menu_segments2[k+1].x1=menu_segments2[k+1].x2=j+1;
    menu_segments1[k+0].y1=menu_segments1[k+0].y2=menu_segments1[k+1].y1=4+hmenu;
    menu_segments2[k+0].y1=menu_segments2[k+0].y2=menu_segments2[k+1].y1=4+hmenu+1;
    menu_segments1[k+1].y2=4;
    menu_segments2[k+1].y2=4+1;
    j+=6;
    k+=2;
  }

  /* add the other windows here...  */
  ybottom_button=8+hmenu+6; /* y start of the windows */
  hbottom_button=font->ascent+3+font->ascent+font->descent;
  hbottom=ybottom_button+hbottom_button+3;
  wbottbutt=(main_xsize-right_window_width-3-hbottom_button-3-(4*nbottbutt))/nbottbutt;

  hwork=main_ysize-hbottom-menuheight;
  wwork=main_xsize-right_window_width;

  /* this is an online rewrite of open_daughter_window that includes a background pixmap */
  xgcv.foreground = doDefineColor(white);
  xgcv.background = xswa.background_pixel =  doDefineColor(light_grey);
  win_work = XCreateWindow (dpy, win_main, 0, menuheight, wwork,
    hwork, 0,XDefaultDepthOfScreen(screen), InputOutput,
    XDefaultVisualOfScreen(screen),CWEventMask | CWBackPixel | CWBackPixmap, &xswa);
  XSetNormalHints (dpy, win_work, &xsh);
  gcwork = XCreateGC (dpy, win_work,GCForeground | GCBackground, &xgcv);
  pixmap =  XCreatePixmapFromBitmapData(dpy,win_work, background_tile,
    grey_width, grey_height, xgcv.foreground, xgcv.background,bitdepth);
  XSetWindowBackgroundPixmap(dpy,win_work,pixmap);
  XMapWindow (dpy, win_work);

  xright=main_xsize-right_window_width+10;
  lright=right_window_width-10;
  hclip=vmoving1;
  open_daughter_window(&win_clipboard,win_main,xright,menuheight,lright,hclip,NULL,black,light_grey,0);
  htoolbar=vmoving2-vmoving1-10;
  open_daughter_window(&win_toolbar,win_main,xright,menuheight+vmoving1+10,lright,htoolbar,NULL,black,light_grey,0);
  hview=main_ysize-menuheight-vmoving2-10;
  open_daughter_window(&win_quickview,win_main,xright,menuheight+vmoving2+10,lright,hview,NULL,black,light_grey,0); 

  open_daughter_window(&win_bottom, win_main, 0,main_ysize-hbottom,main_xsize-right_window_width ,hbottom,NULL, dim_grey,grey34,0);
  open_daughter_window (&win_message,win_bottom,6,8,(main_xsize-right_window_width)-9,hmenu,NULL, black, light_grey, 0 );
  open_daughter_window (&win_status,win_bottom,3,ybottom_button,hbottom_button,hbottom_button,NULL, dim_grey,red,0);

  j=3+hbottom_button+3+4; /* cf above */
  for (i=0;i< nbottbutt;i++) {
    open_daughter_window(&win_bottom_button[i],win_bottom,j,ybottom_button,wbottbutt,hbottom_button,NULL, dim_grey,grey34,0);
    j+=wbottbutt+4;
    functext[i][0]='F';
    if (i<9) {/* one digit */
      functextlength[i]=2;
      functext[i][1]=i+'1';
      functextwidth[i]=XTextWidth(font,functext[i],2);
    } else { /* two digits */
      functextlength[i]=3;
      functext[i][1]=((i+1)/10)+'0';
      functext[i][2]=((i+1)%10)+'0';
      functextwidth[i]=XTextWidth(font,functext[i],3);
    }
  }

  /* resize window 3: */
  open_daughter_window(&button_v_move2, win_main, main_xsize-right_window_width+10,menuheight+vmoving2,right_window_width-10, 10,NULL, dim_grey,grey34,0);
  /* resize window 2: */
  open_daughter_window(&button_v_move1, win_main, main_xsize-right_window_width+10,menuheight+vmoving1,right_window_width-10, 10,NULL, dim_grey,grey34,0);
  /* resize window 1: */
  open_daughter_window(&button_h_move1, win_main, main_xsize-right_window_width,menuheight, 10,hmoving1,NULL, dim_grey,grey34,0);

  fprintf(stderr,"\x0D                                \x0D");

  /* main loop */  
  do {
    XNextEvent(dpy,&event);
    switch(event.type) {

      case ResizeRequest:
        if (event.xresizerequest.window!=win_main)
          break;
resize_main:
        xswa.event_mask&= ~ResizeRedirectMask;
        XChangeWindowAttributes(dpy,win_main,CWEventMask, &xswa);
        XSync(dpy,0); /*<FONT COLOR=#C00000> very important, otherwise we loop endlessly ! </FONT>*/

        XResizeWindow(dpy, win_main,event.xresizerequest.width,event.xresizerequest.height);

        XSync(dpy,0); /*<FONT COLOR=#C00000> very important, otherwise we loop endlessly ! </FONT>*/

        xswa.event_mask|= ResizeRedirectMask;
        XChangeWindowAttributes(dpy,win_main,CWEventMask, &xswa);
        resize=1;
        goto redisplay;

      case Expose:
	if (event.xexpose.count|moving_button1|vmoving_button)
	  break;

        if (event.xexpose.window==win_main){
redisplay:
          XGetGeometry(dpy,win_main,&wdumb,&dumb,&dumb,&main_xsize2,&main_ysize2,&dumb,&dumb);

          i=0;
          if (main_xsize2< min_xsize) {
            main_xsize2=min_xsize;
            i=1;
	  } 
	  if (main_ysize2< min_ysize) {
            main_ysize2=min_ysize;
            i=1;
          } 
          if (i) {
	    printf("main window undersize detected, re-resize manually\n");
	    event.xresizerequest.width=main_xsize2;
	    event.xresizerequest.height=main_ysize2;
	    goto resize_main;
	  }


          if ((resize)||(main_xsize!=main_xsize2)||(main_ysize!=main_ysize2)) {
	    /* recompute the coordinates ! */

            /* this depends on the old coordinates : */
	    i=(right_window_width*main_xsize2)/main_xsize;
                  /* protected from /0 par min_xsize */
            vmoving1=(vmoving1*(main_ysize2-menuheight))/(main_ysize-menuheight);
            vmoving2=(vmoving2*(main_ysize2-menuheight))/(main_ysize-menuheight);

	    /* "validate" the new coordinates */
            main_xsize=main_xsize2;
	    main_ysize=main_ysize2;

	    /* this depends on the new coordinates : */
            XResizeWindow(dpy,win_menu,main_xsize,menuheight);

            hmoving1 = main_ysize-menuheight;

	    resize_move_button1(i,1); /* this triggers the resize of the rest of the windows */
            
	    resize=0;
	  }

	  break;
	}

        if (event.xexpose.window==win_message) {
          XDrawImageString(dpy,win_message,gc2,4,font->ascent+2,bottom_message,msglength);
	  break;
	}
        if (event.xexpose.window==win_menu){
	  /* horizontal fade */
          XDrawLine(dpy,win_menu,gcgrey2,0,menuheight-1,main_xsize,menuheight-1);
          XDrawLine(dpy,win_menu,gcgrey3,0,menuheight-2,main_xsize,menuheight-2);
          XDrawLine(dpy,win_menu,gcgrey4,0,menuheight-3,main_xsize,menuheight-3);
          /* button surrounding */
          XDrawSegments(dpy,win_menu,gcgrey3,menu_segments1,nb_but_menu*2);
          XDrawSegments(dpy,win_menu,gcgrey4,menu_segments2,nb_but_menu*2);
	  break;
        }
        if (event.xexpose.window==win_bottom){
	  /* horizontal fade */
          XDrawLine(dpy,win_bottom,gcgrey2,0,0,main_xsize-right_window_width,0);
          XDrawLine(dpy,win_bottom,gcgrey3,0,1,main_xsize-right_window_width,1);
          XDrawLine(dpy,win_bottom,gcgrey4,0,2,main_xsize-right_window_width,2);
          XDrawSegments(dpy,win_bottom,gcgrey3,bottom_segments1,4);
	  XDrawSegments(dpy,win_bottom,gcgrey4,bottom_segments2,4);
          XDrawSegments(dpy,win_bottom,gcgrey6,bottom_segments3,2*nbottbutt);
          XDrawSegments(dpy,win_bottom,gcgrey7,bottom_segments4,2*nbottbutt);
	  break;
	}
        if (event.xexpose.window==button_h_move1) {
          display_moving_button1(moving_button1);
	  break;
	}
	if (event.xexpose.window==button_v_move1) {
          display_v_moving_button((vmoving_button&(16+8))==16+8,button_v_move1);
	  break;
	}
        if (event.xexpose.window==button_v_move2) {
          display_v_moving_button((vmoving_button&(16+8))==16,button_v_move2);
	  break;
	}
        if (event.xexpose.window==win_work) {
	  display_work();
	  break;
	}
        if (event.xexpose.window==win_quickview) {
	  display_view();
	  break;
	}
/*
        if (event.xexpose.window==win_clipboard) {
          XDrawLine(dpy,win_clipboard,gc2,0,0,lright,hclip);
	  break;
	}
        if (event.xexpose.window==win_toolbar) {
          XDrawLine(dpy,win_toolbar,gc2,0,0,lright,htoolbar);
	  break;
	}
*/
        /* scan the menu buttons */
        for (i=0;i<nb_but_menu;i++) {
          if (event.xexpose.window==button_menu[i]) {
            XDrawImageString(dpy,button_menu[i],gc2,4,font->ascent+2,but_menu_txt[i],strlen(but_menu_txt[i]));
            if ((current_menu)&&(current_menu==i)) {
	      int m=font->ascent+2+hmenu, n=0;
	      /* XDrawLine(dpy,button_menu[i],gc2,0,hmenu,current_menu_width-1,hmenu); */
	      do {
		XDrawImageString(dpy,button_menu[i],gc2,4,m,ptr_menufiles[i][n], strlen(ptr_menufiles[i][n]));
		m+=hmenu;
		n++;
	      } while (ptr_menufiles[i][n]);
	      XDrawRectangle(dpy,button_menu[i],gc2,0,0,current_menu_width-1,current_menu_height-1);
	    }
	    break;
	  }
        }
        /* scan the bottom buttons */
        for (i=0;i<nbottbutt;i++) {
          if (event.xexpose.window==win_bottom_button[i]) {
            XDrawImageString(dpy,win_bottom_button[i],gcbottbutt,(wbottbutt-functextwidth[i])>>1,font->ascent,functext[i],functextlength[i]);
            XDrawImageString(dpy,win_bottom_button[i],gcbottbutt,(wbottbutt-XTextWidth(font,functiontexts[i],strlen(functiontexts[i])))>>1,(1+font->ascent)<<1,functiontexts[i],strlen(functiontexts[i]));
	    break;
	  }
        }

	break;

      case ButtonPress:
	yclick=event.xbutton.y;
	xclick=event.xbutton.x;
	if (event.xbutton.button==1) {
	  buttonspressed|=1;
	  if (event.xbutton.window==win_quickview) {
	    /* we are drawing a zone on qv */
	    quick_scope.x=event.xbutton.x;
	    quick_scope.y=event.xbutton.y;
	    quick_scope.width=0;
	    quick_scope.height=0;
	    XClearWindow(dpy,win_quickview);
	    display_view();
	    break;
	  }
	  if (alt_key &&(event.xbutton.window==win_work)) {
	    break;
	  }
	  if (event.xbutton.window==button_menu[0])
	    goto the_end;
          for (i=1;i < nb_but_menu;i++)
  	    if (event.xbutton.window==button_menu[i]) {
	      int n=0,width;
	      current_menu_width=menu_widths[i];

	      /* context-sensitive : */
              if (i==1) {
		ptr_menufiles[1]=menufiles2;
		if (file_is_modified)
		  ptr_menufiles[1]=menufiles1;
	      }
	      /* setup the window */
	      current_menu=i;
	      do {
		width = XTextWidth(font, ptr_menufiles[i][n], strlen(ptr_menufiles[i][n])) + 8;
		if (width > current_menu_width)
		  current_menu_width = width;
		n++;
	      } while (ptr_menufiles[i][n]);

	      XRaiseWindow(dpy,button_menu[i]);
	      current_menu_height=hmenu*(n+1)+3;
	      XResizeWindow(dpy,button_menu[i],current_menu_width,current_menu_height);
              break;  /* help ! this break only breaks from the for() loop ! */
	    }
	  if (event.xbutton.window==button_h_move1){
            display_moving_button1(moving_button1=1);
	    break;
	  }
	  if (event.xbutton.window==button_v_move1){
            display_v_moving_button(vmoving_button=8+16,button_v_move1);
	    break;
	  }
	  if (event.xbutton.window==button_v_move2){
            display_v_moving_button(vmoving_button=16,button_v_move2);
	    break;
	  }
	}
	if (event.xbutton.button==2) {
	  buttonspressed|=2;
	  if (alt_key || (event.xbutton.window==win_quickview)) {
	    view_everything();
	    break;
	  }

	}
	if (event.xbutton.button==3) {
	  buttonspressed|=4;
	}
        break;

      case ButtonRelease:
	if (event.xbutton.button==1) {
	  buttonspressed&=~1;
	  if (event.xbutton.window==win_quickview) {
	    xview=xmqvbbox+(((xclick+event.xbutton.x-lright)*qvscalediv)/(qvscalemul<<1));
	    yview=ymqvbbox+(((yclick+event.xbutton.y-hview)*qvscalediv)/(qvscalemul<<1));

	    /*have we  drawn a zone on qv ? */
	    if ((xclick!=event.xmotion.x)
	      &&(yclick!=event.xmotion.y)) {

	      /* zoom along x or y ? */
	      if ((quick_scope.width*hwork)>(quick_scope.height*wwork)) {
		zoom=((wwork << COORDSHIFT)*qvscalemul)/(quick_scope.width*qvscalediv);
	      }
	      else {
		zoom=((hwork << COORDSHIFT)*qvscalemul)/(quick_scope.height*qvscalediv);
	      }
	      if (zoom<1)
		zoom=1;
	    }

	    refresh_view();
	    break;
	  }

	  if (moving_button1) {
	    resize_move_button1(right_window_width,1);
	    display_moving_button1(moving_button1=0);
	    break;
	  }
	  if (vmoving_button) {
	    resize_v_button(1);
	    display_v_moving_button(0,event.xbutton.window);
	    break;
	  }
	  for (i=1;i < nb_but_menu;i++)
	    if (event.xbutton.window==button_menu[i]) {
	      XResizeWindow(dpy,button_menu[i],menu_widths[i],hmenu);
	      if (current_menu_line) {
		current_menu_line--;
	        if ((func_array[i]!=NULL)
                  &&(func_array[i][current_menu_line]!=NULL))
		     func_array[i][current_menu_line]();
		current_menu_line=0;
	      }
	      current_menu=0;
	      break;
	    }
	}

	if (event.xbutton.button==2) {
	  buttonspressed&=~2;
          break;
	}
	if (event.xbutton.button==3) {
	  buttonspressed&=~4;
	  break;
	}

        break;

      case MotionNotify:
	if (alt_key) { /* ALT key is being pressed */
	  if (event.xbutton.window==win_work){ /* we're playing with the working window */
	    if (buttonspressed & 1) {  /* scrolling */ 
	      xclick-=event.xmotion.x;  /* hey ! that's dumb, it's exactly */
	      yclick-=event.xmotion.y;  /* what we get from the mouse ! */
	      scroll(-xclick,-yclick);
	      xclick=event.xmotion.x;
	      yclick=event.xmotion.y;
	      break;
	    }
	    if (buttonspressed & 4) {  /* zooming */
	      xclick-=event.xmotion.x;
	      yclick-=event.xmotion.y;
	      if (xclick+yclick<0)
		zoom_out();
	      else
		zoom_in();
	      xclick=event.xmotion.x;
	      yclick=event.xmotion.y;
	      break;
	    }
	  }
	}
	if ((buttonspressed==1)&&(event.xbutton.window==win_quickview)) {
	  /* we are drawing a zone on qv */
	  if (xclick < event.xmotion.x) {
	    quick_scope.width=event.xmotion.x-xclick;
	    quick_scope.x=xclick;
	  }
	  else {
	    quick_scope.width=xclick-event.xmotion.x;
	    quick_scope.x=event.xmotion.x;
	  }
	  if (yclick < event.xmotion.y) {
	    quick_scope.height=event.xmotion.y-yclick;
	    quick_scope.y=yclick;
	  }
	  else {
	    quick_scope.height=yclick-event.xmotion.y;
	    quick_scope.y=event.xmotion.y;
	  }
  
	  XClearWindow(dpy,win_quickview);
	  display_view();
	  break;
	}
        if ((event.xmotion.window==button_h_move1)&&(moving_button1)) {
	  resize_move_button1(right_window_width-(event.xmotion.x-xclick),0);
          break;
	}
        if (vmoving_button) {
          if (vmoving_button&8){ /* if v1 */
	    vmoving1+=event.xmotion.y-yclick;
	    vmoving_button|=1+16;
	    resize_v_button(0);
	    break;
	  } /* else : v2 */
	  vmoving2+=event.xmotion.y-yclick;
	  vmoving_button|=2+32;
	  resize_v_button(0);
          break;
	}

        /* the menu buttons */
        if ((buttonspressed==1)&&(event.xbutton.window==button_menu[current_menu])) {
	  int new_line;
          if ((event.xmotion.y >= 0)&&(event.xmotion.y < (current_menu_height-3))) {
	    new_line=event.xmotion.y / hmenu;
            if (new_line!=current_menu_line){
              if (current_menu_line) {
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey1,1,(current_menu_line*hmenu)-1,current_menu_width-3,hmenu+2);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey1,2,(current_menu_line*hmenu),current_menu_width-5,hmenu);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey1,3,(current_menu_line*hmenu)+1,current_menu_width-7,hmenu-2);
	      }
	      current_menu_line=new_line;
              if (current_menu_line) {
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey6,1,(current_menu_line*hmenu)-1,current_menu_width-3,hmenu+2);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey5,2,(current_menu_line*hmenu),current_menu_width-5,hmenu);
		XDrawRectangle(dpy,button_menu[current_menu],gcgrey3,3,(current_menu_line*hmenu)+1,current_menu_width-7,hmenu-2);
	      }
	    }
	  }
	  break;
        }

        break;

/*	    XDrawPoint(dpy,button_menu[current_menu],gcgrey2,event.xmotion.x,event.xmotion.y);
   if (event.xexpose.window==button_menu[i]) {
   XDrawImageString(dpy,button_menu[i],gc2,4,font->ascent+2,but_menu_txt[i],strlen(but_menu_txt[i]));
   if ((current_menu)&&(current_menu==i)) {
   int m=font->ascent+2+hmenu, n=0;
   /// XDrawLine(dpy,button_menu[i],gc2,0,hmenu,current_menu_width-1,hmenu); ///
   do {
     XDrawImageString(dpy,button_menu[i],gc2,4,m,ptr_menufiles[i][n], strlen(ptr_menufiles[i][n]));
     m+=hmenu;
     n++;
   } while (ptr_menufiles[i][n]);
   XDrawRectangle(dpy,button_menu[i],gc2,0,0,current_menu_width-1,current_menu_height-1);
 */  

      case KeyRelease :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
	switch(keysym) {
          case XK_Alt_L:
            alt_key&= ~1;
	    break;
          case XK_Alt_R:
            alt_key&= ~2;
	    break;
	}        
        break;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;
	switch(keysym) {
          case XK_Page_Up:
	    zoom_out();
	    break;
          case XK_Page_Down:
	    zoom_in();
	    break;
          case XK_Alt_L:
            alt_key|=1;
	    break;
          case XK_Alt_R:
	    alt_key|=2;
	    break;
          case XK_Home:
	    view_everything();
	    break;
	  case XK_Left:
	    scroll(movestep,0);
	    break;
	  case XK_Right:
            scroll(-movestep,0);
            break;
	  case XK_Up:
	    scroll(0,-movestep);
	    break;
	  case XK_Down:
            scroll(0,movestep);
            break;
	}

        break;
    }
  } while (1);

the_end:
  exit_and_save_config(0);
  return 0;
}
