-- File F-CPU_config.vhdl
-- (c) Yann GUIDON, oct. 21, 2000
-- whygee@f-cpu.org / f-cpu@egroups.com
--
-- This package defines the "characteristic widths" of
-- the internal units. Please respect the restrictions.


package FCPU_config is

------------------------------------------------------
-- Most important F-CPU constants :
------------------------------------------------------
  constant MAXSIZE : natural := 8;        -- Size of the registers in bytes, any power of two >= 4.
  constant UMAX : natural := MAXSIZE * 8; -- Size of the registers in bits.
  constant F_RANGE : natural := UMAX-1;   -- Range of a register width declaration.

------------------------------------------------------
-- Some architectural constants, bound to FC0 only :
------------------------------------------------------

-- L1 Caches (split instructions and data)
  L1DBwidth  : natural := 256 ; -- Data Bus width, or width of each cache line (32 bytes)
  L1ABwidth  : natural := 32  ; -- Address Bus width, in 32-byte chuncks (32+5=128GB)
  L1LogLines : natural := 6   ; -- Log2 of the NumBer of cache Lines (MUST be EVEN)
  L1NBlines  : natural := 64  ; -- NumBer of cache Lines (2**LogLines) (small number for the first attempts)


------------------------------------------------------
-- The Special Registers :
-- (copied from SR.h)
------------------------------------------------------

  constant SR_NUMBERS      : natural := 0;
  constant SR_NUMBERS_val  : natural := 10;      -- 10 SRs are implemented in this model

  constant SR_FAMILY       : natural := 1;
  constant SR_FAMILY_val   : natural := X"FC0";  -- F-CPU core number, or whatever */

  constant SR_STEPPING     : natural := 2;
  constant SR_STEPPING_val : natural := X"1";    -- revision/implementation */

  constant SR_MAX_SIZE     : natural := 3;
  constant SR_MAX_SIZE_val : natural := MAXSIZE; -- in bytes, a power of two >= 4 */

  constant SR_SIZE_1       : natural := 4;
  constant SR_SIZE_1_val   : natural := 1;       -- Size attribute 1, hardwired if SR_MAX_SIZE <= 8 */

  constant SR_SIZE_2       : natural := 5;
  constant SR_SIZE_2_val   : natural := 2;       -- Size attribute 2, hardwired if SR_MAX_SIZE <= 8 */

  constant SR_SIZE_3       : natural := 6;
  constant SR_SIZE_3_val   : natural := 4;       -- Size attribute 3, hardwired if SR_MAX_SIZE <= 8 */

  constant SR_SIZE_4       : natural := 7;
  constant SR_SIZE_4_val   : natural := 8;       -- Size attribute 4, hardwired if SR_MAX_SIZE <= 8 */

  constant SR_CYCLE        : natural := 8;       -- R/W, Value is dynamic, incremented every cycle.

  constant SR_PAGING       : natural := 9;       -- Protected, R/W, Controls the paged memory.

end FCPU_config;


package FCPU_config is

------------------------------------------------------
-- Empty. Only the constants matter until today.
-- Some useful wrappers or functions could be included
-- here if they are necessary for the project.
------------------------------------------------------

end FCPU_config;

