-- iadd8.vhdl -- F-CPU 8-Bit Adder
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: iadd8.vhdl,v 1.3 2000/10/22 12:15:34 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity IAdd8 is
        generic (
                WIDTH : natural := 8    -- do not change!
        );
        port (
                -- summands
                A : in std_ulogic_vector(WIDTH-1 downto 0);
                B : in std_ulogic_vector(WIDTH-1 downto 0);
                -- carry input
                Cin : in std_ulogic;
                -- sum output
                Y : out std_ulogic_vector(WIDTH-1 downto 0);
                -- carry output
                Cout : out std_ulogic
        );
end IAdd8;

architecture Arch_1 of IAdd8 is
        signal P, W, X, C1, C2 : std_ulogic_vector(WIDTH-1 downto 0);
        signal X_6_3 : std_ulogic;
begin
        -- d=1
        P <= A and B;
        X <= A xor B;
        -- d=2
        X_6_3 <= '1' when X(6 downto 3) = "1111" else '0';
        -- d=3
        C1 <= (
                7 => P(6)
                  or (X(6) and P(5))
                  or (X(6) and X(5) and P(4))
                  or (X(6) and X(5) and X(4) and P(3)),
                6 => P(5)
                  or (X(5) and P(4))
                  or (X(5) and X(4) and P(3)),
                5 => P(4)
                  or (X(4) and P(3)),
                4 => P(3),
                3 => P(2)
                  or (X(2) and P(1))
                  or (X(2) and X(1) and P(0))
                  or (X(2) and X(1) and X(0) and Cin),
                2 => P(1)
                  or (X(1) and P(0))
                  or (X(1) and X(0) and Cin),
                1 => P(0)
                  or (X(0) and Cin),
                0 => Cin
        );
        -- d=4
        W <= X xor C1;
        C2 <= (
                7 => X_6_3 and C1(3),
                6 => X(5) and X(4) and X(3) and C1(3),
                5 => X(4) and X(3) and C1(3),
                4 => X(3) and C1(3),
                3 downto 0 => '0'
        );
        -- d=5
        Y <= W xor C2;
        Cout <= P(7)
                 or (X(7) and C1(7))
                 or (X(7) and X_6_3 and C1(3));
end Arch_1;
