-- t-imul.vhdl - F-CPU 8x8-Bit Integer Multiplication Unit
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: t-imul.vhdl,v 1.1 2000/10/07 23:40:07 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;
use IEEE.std_logic_textio.all;

entity mul9x9_test is
end mul9x9_test;

architecture Arch_1 of mul9x9_test is
        signal A, B : std_ulogic_vector(8 downto 0);
        signal X, Y : std_ulogic_vector(15 downto 0);
begin
        mut: entity work.Mul9x9
                port map (A => A, B => B, X => X, Y => Y);

        process
                variable i, j, k, prod, res : integer;
                variable lout : line;
        begin
                write(lout, "*******************************************");
                writeline(output, lout);
                write(lout, "Multiplier Testbench (C) 2000 Michael Riepe");
                writeline(output, lout);
                write(lout, "*******************************************");
                writeline(output, lout);
                write(lout, "Expect this to run for quite some time...");
                writeline(output, lout);
                write(lout, "Get some coffee now, or go dating your SO.");
                writeline(output, lout);
                writeline(output, lout);

                write(lout, "*** Testing 8-bit signed multiplication");
                writeline(output, lout);
                for i in -128 to 127 loop
                        A <= std_ulogic_vector(to_signed(i, A'length));
                        for j in -128 to 127 loop
                                B <= std_ulogic_vector(to_signed(j, B'length));
                                for k in -128 to 127 loop
                                        X <= std_ulogic_vector(to_signed(k, X'length));
                                        wait for 1 ns;
                                        res := to_integer(signed(Y));
                                        prod := i * j + k;
                                        if (res /= prod) then
                                                write(lout, "WHOA THERE!!! ");
                                                write(lout, i);
                                                write(lout, " * ");
                                                write(lout, j);
                                                write(lout, " + ");
                                                write(lout, k);
                                                write(lout, " => ");
                                                write(lout, Y);
                                                write(lout, " /= ");
                                                write(lout, prod);
                                                write(lout, " d = ");
                                                write(lout, res - prod);
                                                writeline(output, lout);
                                        end if;
                                end loop;
                        end loop;
                end loop;

                write(lout, "*** Testing 8-bit unsigned multiplication");
                writeline(output, lout);
                for i in 0 to 255 loop
                        A <= std_ulogic_vector(to_unsigned(i, A'length));
                        for j in 0 to 255 loop
                                B <= std_ulogic_vector(to_unsigned(j, B'length));
                                for k in 0 to 255 loop
                                        X <= std_ulogic_vector(to_unsigned(k, X'length));
                                        wait for 1 ns;
                                        res := to_integer(unsigned(Y));
                                        prod := i * j + k;
                                        if (res /= prod) then
                                                write(lout, "WHOA THERE!!! ");
                                                write(lout, i);
                                                write(lout, " * ");
                                                write(lout, j);
                                                write(lout, " + ");
                                                write(lout, k);
                                                write(lout, " => ");
                                                write(lout, Y);
                                                write(lout, " /= ");
                                                write(lout, prod);
                                                write(lout, " d = ");
                                                write(lout, res - prod);
                                                writeline(output, lout);
                                        end if;
                                end loop;
                        end loop;
                end loop;
                wait;
        end process;
end Arch_1;
