--------------------------------------------------------------------
-- F-CPU project : Instruction cache specification
-- Yann Guidon, oct. 3, 2000 (2am) with a lot of material
-- from the f-cpu@egroups.com mailing list (mostly Michael & Colin)
-- This file provides only the declaration and the generics for
-- the Icache of the FC0. It also sums up the coding conventions
-- adopted for the VHDL sources of the project.
--------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

ENTITY  Icache_type  IS
  GENERIC(
    DBwidth  : natural := 256 ; -- Data Bus width, or width of each cache line (32 bytes)
    ABwidth  : natural := 32  ; -- Address Buss width, in 32-byte chuncks (32+5=128GB)
    LogLines : natural := 6   ; -- Log2 of the NumBer of cache Lines (MUST be EVEN)
    NBlines  : natural := 64    -- NumBer of cache Lines (2**LogLines) (small number for the first attempts)
  );
  PORT(
   Clk, Inv_En, Reset, Read_En, Write_En, Freeze_En : IN Boolean;
   Address_read, Address_write, Address_Mask : IN Std_ulogic_vector(ABwidth-1 downto 0);
-- "natural" should be used for the addresses, right ? But how do we handle
-- the AND with the masks ?
   Icache_hit : OUT Boolean;
   Din  :  IN Std_ulogic_vector(DBwidth-1 downto 0);
   Dout : OUT Std_ulogic_vector(DBwidth-1 downto 0)
  );
END Icache_type;

-- this file was compiled and simulated (empty arch) with simili.