#include <stdio.h>

#include "cache01.c"

void print_LRU(void) {
  int i;
  for (i=0; i<MAX_LINES; i++) 
    printf("%d, ",ILRUtags[i]);
  putchar('\n');
}

/* the following two functions are for use for a simulator.
  reading cache lines is used by the fetcher, invalidating lines
  is used by the memory controller. They use the same address lines
  and they are exclusive : they should be called with a mutual
  exclusion flag for the synchronisation. These functions are
  NOT YET cycle accurate. */

void high_level_read_Icache_line(long int address){
  Iaddress_read=address;
  read_Icache_line ();
  if (Icache_hit==0) {
    /* sorry, here we don't simulate the fetcher's buffers (yet). */

    /* fetch data here, put it in IcacheIn */
    printf ("fetch %d\n",address);


    memcpy (IcacheOut,IcacheIn,32);
    Iaddress_write=address;
    write_Icache_line();

  } else {
    printf("hit %d !\n",address);
  }
  /* now, the data is available in IcacheOut */
}

void high_level_invalidate_Icache_line(long int address){
  Iaddress_read=address;
  invalidate_Icache_line();
}

int main (void) {
  reset_LRU();
  print_LRU();
  high_level_read_Icache_line(125000);
  print_LRU();
  high_level_read_Icache_line(126000);
  print_LRU();
  high_level_read_Icache_line(127000);
  print_LRU();
  high_level_invalidate_Icache_line(126000);
  print_LRU();
  high_level_read_Icache_line(125000);
  print_LRU();
  high_level_read_Icache_line(126000);
  print_LRU();
  high_level_read_Icache_line(127000);
  print_LRU();
  return 0;
}

/*

output should look like :

bash-2.03$ gcc -g -Wall -ansi test.c 
cache01.c: In function `invalidate_Icache_line':
In file included from test.c:3:
cache01.c:96: warning: int format, long int arg (arg 2)
test.c: In function `high_level_read_Icache_line':
test.c:26: warning: int format, long int arg (arg 2)           <- harmless warnings
test.c:34: warning: int format, long int arg (arg 2)
bash-2.03$ ./a.out 
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
fetch 125000
15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
fetch 126000
14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 
fetch 127000
13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
Line @126000 removed from cache
13, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 
hit 125000 !
15, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 
fetch 126000
14, 15, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
hit 127000 !
13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
bash-2.03$ 

 */
