#include <stdio.h>

#define NODE bool
#define HI true
#define LO false


// ########## 2 input AND Gate ###################
class and2 {

public:

NODE *in1, *in2, *out;

and2::and2 (NODE *_in1,
                NODE *_in2,
                NODE *_out) {
  in1=_in1;
  in2=_in2;
  out=_out;
};

void and2::delta () {
  *out=*in1 && *in2;
};


}; //end class and2



// ########### 2 input NAND Gate #################
class nand2 {

public:

NODE *in1,*in2,*out;

nand2::nand2 (NODE *_in1,
                  NODE *_in2,
                  NODE *_out) {
  in1=_in1;
  in2=_in2;
  out=_out;
}

void nand2::delta () {
  if(*in1 && *in2) {
    *out=LO;
  } else {
    *out=HI;
  };
};

}; //end class nand2



//###################### Tristate Buffer #################

class tribuf1 {

public:

 NODE *in,*enable,*out;

tribuf1::tribuf1 (NODE *_in,
                       NODE *_enable,
                       NODE *_out) {
   in=_in;
   enable=_enable;
   out=_out;
 };

 void tribuf1::delta () {
   if(enable) *out=*in;
 };

}; //end class tribuf1



//################### D Type Flip Flop #######################

class dtype1 {

public:

NODE oldclock,*in,*clock,*out;


dtype1::dtype1 (NODE *_in,
                    NODE *_clock,
                    NODE *_out) {
  in=_in;
  clock=_clock;
  out=_out;
};

void dtype1::delta () {
  if (oldclock == LO && *clock == HI) {
    //positive edge so
    *out=*in;
  };
  oldclock = *clock;
};

}; //end of class dtype1
//---------------------------------------------------



//parts to complete:

//dtype1_32
//tribuf1_32
//and2_32
//nand2_32
//invert1_32
//add2_32 perhaps join up many add2_4??


void main() {

  NODE a,b,c;
  and2 gate1(&a,&b,&c);
  a=HI;  b=HI;
  gate1.delta();
  if (c) {
    printf ("and (11) results in TRUE\n\r");
  } else {
    printf ("and (11) results in FALSE\n\r");
  };

  a=HI;  b=LO;
  gate1.delta();
  if (c) {
    printf ("and (10) results in TRUE\n\r");
  } else {
    printf ("and (10) results in FALSE\n\r");
  };

  a=LO;  b=HI;
  gate1.delta();
  if (c) {
    printf ("and (01) results in TRUE\n\r");
  } else {
    printf ("and (01) results in FALSE\n\r");
  };

  a=LO;  b=LO;
  gate1.delta();
  if (c) {
    printf ("and (00) results in TRUE\n\r");
  } else {
    printf ("and (00) results in FALSE\n\r");
  };

  //buses will be done thus
  //const buswidth=32;
  //NODE a[buswidth];



} //end main













