  /*

         F-CPU CORE #0 simulator #2
             Whygee 9/29/1999

    This file gets included in the main
    simulator file ("fcpu_general_01.c")

    This file describes the "register set"
    ("r7" for a short frenchism) component
    of the FC0 core simulator.

   */
   

/* The register set himself : */
UMAX  registers[64];
/* The associated flags */
u64 flag_zero, f0[MAXSIZE]; /* flag_zero is the OR sum of all the f0's */


/* The register set ports, as only interface with other modules */
#define READPORTS 3
#define WRITEPORTS 2

UMAX r7_readport[READPORTS], r7_writeport[WRITEPORTS];
/* The register number associated to each port */ 
u8 r7_rp_num[READPORTS], r7_wp_num[WRITEPORTS];
/* Enables each byte in the written word */
unsigned long int r7_wp_mask[WRITEPORTS];

/*
  
    EXAMINE FUNCTIONS

 */


/* displays a register's content */
void display_register(u8 r) {
 u8  number,mask,temp[]="(0+) ";

 printf("R%02d:",r);
 display_value(MAXSIZE,registers[r]);

/* zero, carry, neg */
 number=r>>3;
 mask=1<<(r & 7);
 if (flag_zero[number] & mask)
  temp[1]='1';
 if (registers[r][MAXSIZE-1] & 128)
  temp[2]='-';
 printf(temp);
}


void display_register_set (void) {
 u8 i, r=0;
 for (i=0; i<32; i++) {
  display_register(r++);
  display_register(r++);
  putchar('\n');
 }
 putchar('\n');
}


/*

    CYCLE FUNCTION

 */

/*
warning, i don't know for sure which order
is best : read then write or write then read ?
*/

void cycle_r7 (void) {
 int i,j,k,mask,pos,num;
 u8 l;
/* Write first */
 for (i=0;i<WRITEPORTS;i++) {
   num=r7_wp_num[i];
   if (num) {  /* don't write r0 */
    k=r7_wp_mask[i];
    pos=num>>3;
    mask=1<<(num & 7);
    
    l=0;
    /* byte per byte copy, according to the mask */
    for (j=0;j<MAXSIZE;j++) { 
     if (k&1) { /* test the LSB */
       /* copy the byte and update the partial zero flag */
      registers[num][j]=r7_writeport[i][j];
      if (r7_writeport[i][j])
       f0[pos][j]|= mask;  /* partial OR */
      else
       f0[pos][j]&=~mask;
     }
     l|=f0[pos][j]; /* OR all the partial vars together */
     k>>=1;
    }
    flag_zero[pos]=l; /* write back the result of the big OR */
    r7_wp_num[i]=0; /* clear in prevision of the next clock cycle */
    r7_wp_mask[i]=0; /* (same) */
   }
 }

/* then read */
 for (i=0;i<READPORTS;i++) {
  memcpy (r7_readport[i],registers[r7_rp_num[i]],MAXSIZE);
 }
}

