 /*

 F-CPU CORE #0 simulator
 Whygee 9/13/1999

adapted from :

       Gamma project
 programming model simulator
       Whygee 1/1999

Sept 13: here, i want to create a functionning
FC0 pipeline simulator in order to test the
ideas of OOOC (Out Of Order Completion).
I adapted it from the Gamma because:
- most of the dirty work has already been done
- i know the code because i did it
- it is close to the F-CPU project, i just have
  to adapt it a bit.

REMARK: you can play with MAXSIZE at will...

 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/* declaration */
void fault(char * message);

/* for the simulator */
typedef unsigned long int uli;
/* "uli" is used when much precision is needed, at least 32 bits.
   "int" is used when simple numbers (less than 1000 for example) are used.*/

/* Programming model type definitions : */

/* for the processor */
typedef unsigned char u8;
typedef unsigned char u16[2];
typedef unsigned char u32[4];
typedef unsigned char u64[8];

/* implementation dependent: */
#define MAXSIZE 8
#define UMAX u64
/* here, the characteristic data size is 64 bits */

UMAX const_zero; /* used to add constant numbers through the carry */

/* Programming model blocks : */

/* the four bytes that hold the instruction : */
u8 ic0,ic1,ic2,ic3;

/* definition of the registers: */
UMAX  registers[64];
/* The associated flags */
u64 flag_zero, f0[MAXSIZE];


/* Some Special Purpose Registers */
#define MAXSPR 9
uli int_val[4],max_int_value;
UMAX cycle_count,MSR,PC;

char *SPRname[]={
 "MAXSPR",
 "MSR",
 "CYCLE",
 "MAXSIZE",
 "SIZE0",
 "SIZE1",
 "SIZE2",
 "SIZE3",
 "PC"
};


/* Definition of "properties" */

#define EXECUTABLE 1
#define WRITEONLY  2
#define READONLY   4
#define READWRITE  6

/* for a beginning: */
#define MAXMEMTYPE 4

struct memory_descriptor_type {
 UMAX
  /*speed,   in processor cycles per block */
  /* latency, in processor cycles */
  properties, /* RWX etc */
   /*  granularity, in bytes */
  index,       /* in bytes */
  size;        /* in bytes */
 u8 * pointer; /* points to the actual memory in the simulator */
} memory_descriptor [MAXMEMTYPE];

/*
    SOME LOW LEVEL ROUTINES
 */

void error(char * message) {
 printf("\n\nSimulator error: %s\n",message);
 exit(-1);
}

/* converts a word to an int */
uli read_value (uli size, u8 *c) {
 uli t=0;

 do {
  size--;
  t<<=8;
  t|=c[size];
 } while (size);

 return t;
}

/* converts an int to a word */
void write_value (uli size, u8 *c, uli value) {
 do {
  *(c++)= (u8)(value);
  value>>=8;
  size--;
 } while (size);
}

/* compares two words */
int compare_superior_values(uli size, u8 * s1, u8 *s2) {
 do {
  size--;
  if (s1[size]>s2[size]) return 1;
  if (s1[size]<s2[size]) return 0;
 } while (size);
 return 0;
}

int compare_equal_values(uli size, u8 * s1, u8 *s2) {
 do {
  size--;
  if (s1[size]!=s2[size]) return 0;
 } while (size);
 return 1;
}

/* adds two words with carry */
int add_values (uli size, u8 *res, u8 *op1, u8 *op2, uli carry) {
 uli i=0, j=carry;
 do {
  j+=op1[i]+op2[i];
  res[i]=(char)j;
  j>>=8;
  i++;
 } while (i<size);
 return j;
}

/* displays a word */
void display_value(uli size, u8 *c) {
 do
  printf("%02X",c[--size]);
 while (size);
}


 /* returns a pointer to the memory pointed to by a PFQ */ 
/* u8 * get_pointer(u8 pfq, uli size) { */
/*  UMAX temp; */
/*  u8 * p; */
/*  p=memory_descriptor[PFQ[pfq].memory_type].pointer */
/*   +read_value(MAXSIZE,PFQ[pfq].index); */
 /* check the bounds */ 
/*  add_values(MAXSIZE,temp,PFQ[pfq].index,const_zero,size); */
/*  if (compare_superior_values(MAXSIZE,temp,PFQ[pfq].limit)) */
/*    return NULL; */
/*  return p; */
/* } */


/* displays a register's content */
void display_register(u8 r) {
 u8  number,mask,temp[]="(0+) ";

 printf("R%02d:",r);
 display_value(MAXSIZE,registers[r]);

/* zero, carry, neg */
 number=r>>3;
 mask=1<<(r & 7);
 if (flag_zero[number] & mask)
  temp[1]='1';
 if (registers[r][MAXSIZE-1] & 128)
  temp[2]='-';
 printf(temp);
}


/* write to a register and update the flags */
void write_register (uli size, u8 reg, u8 *s, u8 update) {
 u8   *d,  /* destination */
  t, regn, mask; /* some temp data */

 if (reg>0) { /* do not write GPR0 */

   /* flags */
  regn=reg>>3;
  mask=1<<(reg & 7);

  /* data copy */
  d=registers[reg];
  do {
   t=s[size];
   f0[regn][size] &= ~mask;
   if (t!=0)
    f0[regn][size]|= mask;  /* partial OR */
   d[size]=t;
   size--;
  } while (size);

   /* zero flag(s) : OR all the partial ORs together */
  flag_zero[regn]=0;
  for (mask=0; mask<MAXSIZE; mask++)
   flag_zero[regn] |= f0[regn][mask];
 }
}

/* read from a register */
void read_register (uli size, u8 reg, u8 *d, u8 update) {
 u8 *s,reg_; /* source */
   /* copy the data data */
  memcpy (d,registers[reg],size);
}

void write_processor_state (void) {
 u8 i,r;

 /* GPR */
 r=0;
 for (i=0; i<32; i++) {
  display_register(r++);
  display_register(r++);
  putchar('\n');
 }
 putchar('\n');
}

void fault(char * message) {
 printf("\n\nProcessor fault: %s\nProcessor state follows:\n",message);
 write_processor_state ();
 exit(-1);
}

u8 h2c(u8 c) {
 if (c>'9') return c-'A'+10;
 return c-'0';
}

u8 f_ok(FILE *file) {
 int i=fgetc(file);
 if (i==EOF) return 0;
 ungetc(i,file);
 return 1;
}

void initialize_processor (char *filename) {
FILE *file;
uli i, index, size;
u8 *p;
u8 buf[20];
u8 not_loaded=1;

/* reset the registers */
 memset(registers, 0, sizeof(registers));
 memset(f0, 0, sizeof(f0));
 memset(flag_zero, 0, 8);

/* The Special Purpose Registers */
 memset(cycle_count, 0, MAXSIZE);
 max_int_value=MAXSIZE;
 int_val[0]=1; /* in bytes */
 int_val[1]=2;
 int_val[2]=4;
 int_val[3]=8;

/* MSR is not used here... */

/* Memory properties descriptors */
 memset(memory_descriptor, 0, sizeof(memory_descriptor));

/* read the object file: */
 file=fopen(filename,"rb");
 if (file==NULL) error("can't open source file");
 printf("\nReading file : %s\n\n",filename);

 while (f_ok(file)) {
  /* search the space number  */
  do {
   p=fgets(buf,sizeof(buf),file);
   if (p==NULL)
    error("can't read source file");
   if (strncmp("EOF",buf,3)==0)
    goto exit_loop; /* end of file */
  } while (strncmp("$Space ",buf,7));
  i=atoi(&buf[7]);
  if (i>=MAXMEMTYPE)
   error ("memory type number too big");
  if (memory_descriptor[i].pointer!=NULL)
   error("space already defined");

  /* search the properties */
  do {
   memset(buf, 0, sizeof(buf));
   p=fgets(buf,sizeof(buf),file);
  } while ((p!=NULL)&&(strncmp("$Properties ",buf,12)!=0));
  /* search R */
  if ((buf[14]=='R')|(buf[12]=='R')|(buf[13]=='R'))
   memory_descriptor[i].properties[0]=READONLY;
  if ((buf[14]=='W')|(buf[12]=='W')|(buf[13]=='W'))
   memory_descriptor[i].properties[0]|=WRITEONLY;
  if ((buf[14]=='X')|(buf[12]=='X')|(buf[13]=='X'))
   memory_descriptor[i].properties[0]|=EXECUTABLE;

  /* search the index */
  do
   p=fgets(buf,sizeof(buf),file);
  while ((p!=NULL)&&(strncmp("$Index ",buf,7)!=0));
  index=atoi(&buf[7]);

  /* search the size */
  do
   p=fgets(buf,sizeof(buf),file);
  while ((p!=NULL)&&(strncmp("$Size ",buf,6)!=0));
  size=atoi(&buf[6]);

  if ((p=malloc(index+size))==NULL) error ("not enough memory for loading a space");
  write_value (MAXSIZE,memory_descriptor[i].size,index+size);
  write_value (MAXSIZE,memory_descriptor[i].index,index);
  memory_descriptor[i].pointer=p;
  memset(p,0,index+size); /* clears the part before the actual beginning */

  while (size>0) {
   fgets(buf,sizeof(buf),file);
   p[0]=(h2c(buf[0])<<4)|h2c(buf[1]);
   p[1]=(h2c(buf[2])<<4)|h2c(buf[3]);
   p[2]=(h2c(buf[4])<<4)|h2c(buf[5]);
   p[3]=(h2c(buf[6])<<4)|h2c(buf[7]);
   size-=4;
   p+=4;
  }

  not_loaded=0;
 }
exit_loop:
 fclose(file);

 if (not_loaded)
  error ("nothing has been loaded.");
 if (compare_equal_values(MAXSIZE, const_zero,memory_descriptor[0].size))
  error ("SPACE#0 (start CPFQ) has not been defined.");

/* PreFetch Queues */

 memset(PC, 0, sizeof(PC)); /* initial "instruction pointer" */

 /* not used but can be useful later: */
/*  memcpy(PFQ[0].limit,memory_descriptor[0].size,MAXSIZE); */
/*  memcpy(PFQ[0].properties,memory_descriptor[0].properties,MAXSIZE); */
/*  memcpy(PFQ[0].index,memory_descriptor[0].index,MAXSIZE); */
}

void fetch_instruction(void) {
 UMAX temp;
 uli i;
 u8 *p;

/* increment the cycle counter : */
 add_values(MAXSIZE,cycle_count,cycle_count,const_zero,1);
 printf("Cycle #");
 display_value(MAXSIZE,cycle_count);

/* round the instruction's index */
 PC[0] &= ~3;
/* check the bounds */
 write_value(MAXSIZE,temp,3);
 add_values(MAXSIZE,temp,PC,temp,0);
 if (compare_superior_values(MAXSIZE,temp,memory_descriptor[0].size))
  fault ("instruction fetch past the buffer limit");

 printf(", ");

/* read the index */
 i=read_value(MAXSIZE,PC);

/* fetch the instruction : */
 p=memory_descriptor[0].pointer;
 ic0=p[i];
 ic1=p[i+1];
 ic2=p[i+2];
 ic3=p[i+3];

 printf("\n  Instruction: %02X%02X%02X%02X, Current index: ",
  ic0,ic1,ic2,ic3);
 display_value(MAXSIZE,PC);
 putchar('\n');

/* increment the instruction pointer : */
 add_values(MAXSIZE,PC,PC,const_zero,4);
}

u8 decode_instruction(void) {
 /*
    returns 0 when OK
    returns 1 when end of stream met
    returns 2 when wrong opcode
 */

/*

This is the most sensitive part of the software...

*/

 UMAX temp, temp2, res;
 uli imm14,imm16,size2,i;
 u8 t,t2,r,format3,op6,place4,dest7,sourceA7,sourceB7;

/* some early and common field decoding: */
 format3=ic0>>5;
 op6=((ic0<<1)|(ic1>>7)) & 63;
 size2=int_val[ic2>>6];
 dest7=ic1 & 127;
 sourceA7=((ic2 & 63)<<1)|(ic3>>7);
 sourceB7=ic3 & 127;

 printf("!\n");

 return 0;
}

/* loop */
int main() {
 u8 c,d;
 initialize_processor ("out.lst");
 do {
  fetch_instruction();
  d=decode_instruction();
  if (d==2)
   fault ("unknown opcode");
  if (d==1) break;
  c=getchar();
  if (c=='r')
   write_processor_state ();
 } while (c!='q');
 printf ("\nSimulator finished.\n");
 return 0;
}
