#include <string.h>
#include <signal.h>

#include "winutils.c"

/* assigns the window numbers : */
#define W_main          0
#define W_mem           1
#define W_LSU           2
#define W_LSU_tags      3
#define W_fetch_logic   4
#define W_fetcher_tags  5
#define W_fetcher       6
#define W_TLB           7
#define W_decoder       8
#define W_scoreboard    9
#define W_register     10
#define W_SR           11
#define W_Xbar         12
#define W_ROP2         13
#define W_INC          14
#define W_SHUFFLER     15
#define W_ASU          16
#define W_IMU          17
#define W_IDU          18
/* last, but not used for real, is : */
#define W_LAST         19

/* assigns the window's names */
char *window_names[W_LAST]={
"main_window",
"memory",
"LSU",
"LSU_tags",
"fetch_logic",
"fetcher_tags",
"fetcher",
"TLB",
"decoder",
"scoreboard",
"register",
"SR",
"Xbar",
"ROP2",
"INC",
"SHUFFLER",
"ASU",
"IMU",
"IDU"
};

/* X11 stuffs */

Window button_[W_LAST];
Window button_hide_[W_LAST];
Window win_[W_LAST];
GC gc_[W_LAST];
int xsize_[W_LAST];
int ysize_[W_LAST];
int hide_[W_LAST];

/* main window */
/* int main_xsize=600, main_ysize=600; */
Window button_quit; /*  10,10,45,17 */
Window button_init; /*  70,10,45,17 */
Window button_step; /* 125,10,45,17 */
XSegment main_segments[30];

long int resize_flag=-1L;
int t1,t2,t3,i;
GC gc1,gc2,gc3;
XEvent event;
KeySym keysym;
char car;

/* could be useful later.... */
void sighandler(int sig)
{
  /* little subliminal message for the masses */
  fprintf(stderr,"\n\nSignal %d\n", sig);
  fprintf(stderr,"Please report errors, bugs, whatever, to whygee@mime.up8.edu\n");
  fprintf(stderr,"(and yes i use 9wm, and yes, flames go to /dev/null)\n\n");
  exitX();
  exit(0);
}

void main(int argc, char **argv)
{

  /* var init : */

  xsize_[0]=600;
  ysize_[0]=600; /* W_main */
  hide_[0]=SHOWN;

  for (i=1; i<W_LAST; i++) {
    xsize_[i]=400; 
    ysize_[i]=400;   /* secondary windows */
    hide_[i]=HIDDEN;
  }


  /* little subliminal message for the masses */
  printf("\n\nF-CPU Core #1 (\"FC1\") simulator\nversion 19991215, (c) by whygee\n");
  printf("GPL applies.\n\n");

  signal(  2, sighandler);
  signal(  3, sighandler);
  signal( 15, sighandler);

  /* read the init file here, eventually remember the window positions.... */

  /* init the simulation here */

  /* X11 */
  init_X();

redisplay:

  if (resize_flag & 1) {

                        /* Create the main window */

    /* dimension fixup */
    if (xsize_[0]<350) {
      xsize_[0]=350;
    }
    if (ysize_[0]<350) {
      ysize_[0]=350;
    }

    /* main window */
    open_window(&win_[0],xsize_[0], ysize_[0],&gc_[0],black,grey,window_names[0],hide_[0]);

    /* function buttons : */
    open_daughter_window (&button_quit, win_[0],  10, 10, 45, 17, &gc1, black, light_grey, 1);
    open_daughter_window (&button_init, win_[0],  70, 10, 45, 17, &gc2, black, light_grey, 1);
    open_daughter_window (&button_step, win_[0], 125, 10, 45, 17, &gc3, black, light_grey, 1);

    /* memory subwindow */
    
    t1=((xsize_[0]-20)/9);
    t2=((ysize_[0]-150)/5);
    t3=((ysize_[0]-10)-(t2+160));

    open_daughter_window (&button_[W_mem],
      win_[0], 10, 50, xsize_[0]-26, 50, &gc_[W_mem],
        black, light_grey, 3);
    open_daughter_window (&button_[W_LSU],
      win_[0], 10, 130, (t1*3)-4, t2-10, &gc_[W_LSU],
        black, light_grey, 3);
    open_daughter_window (&button_[W_LSU_tags],
      win_[0], (t1*3)+10, 130, t1-4, t2-10, &gc_[W_LSU_tags],
        black, light_grey, 3);
    open_daughter_window (&button_[W_fetch_logic],
      win_[0], (t1*4)+10, 130, t1-4,     t2-10, &gc_[W_fetch_logic],
        black, light_grey, 3);
    open_daughter_window (&button_[W_fetcher_tags],
      win_[0], (t1*5)+10, 130, t1-4,     t2-10, &gc_[W_fetcher_tags],
        black, light_grey, 3);
    open_daughter_window (&button_[W_fetcher],
      win_[0], (t1*6)+10, 130, (t1*3)-4, t2-10, &gc_[W_fetcher],
        black, light_grey, 3);
    open_daughter_window (&button_[W_TLB],
      win_[0], (((xsize_[0]-20)*3)>>3)+10, t2+160, ((xsize_[0]-20)>>2), t2-20, &gc_[W_TLB],
        black, light_grey, 3);
    open_daughter_window (&button_[W_decoder],
      win_[0], (t1*6)+30,      t2+160,(t1*3)-30,      t2-10, &gc_[W_decoder],
        black, light_grey, 3);
    open_daughter_window (&button_[W_scoreboard],
      win_[0], (t1*6)+30,  (t2*2)+160, (t1*3)-30,     t2-30, &gc_[W_scoreboard],
        black, light_grey, 3);
    open_daughter_window (&button_[W_register],
      win_[0], (t1*6)+30,  (t2*3)+140, (t1*3)-30,     t2+10, &gc_[W_register],
        black, light_grey, 3);
    open_daughter_window (&button_[W_SR],
      win_[0], (t1*6)+30,  (t2*4)+160, (t1*3)-30,     t2-30, &gc_[W_SR],
        black, light_grey, 3);
    open_daughter_window (&button_[W_Xbar],
      win_[0], (t1*4)+20,  (t2*2)+180,        t1, (t2*3)-50, &gc_[W_Xbar],
        black, light_grey, 3);
    open_daughter_window (&button_[W_ROP2],
      win_[0], 10,             t2+160, (t1*3)-20,  (t3/6)-8, &gc_[W_ROP2],
        black, light_grey, 3);
    open_daughter_window (&button_[W_INC],
      win_[0], 10,      (t3/6)+t2+160, (t1*3)-20,  (t3/6)-8, &gc_[W_INC],
        black, light_grey, 3);
    open_daughter_window (&button_[W_SHUFFLER],
      win_[0], 10,      (t3/3)+t2+160, (t1*3)-20,  (t3/6)-8, &gc_[W_SHUFFLER],
        black, light_grey, 3);
    open_daughter_window (&button_[W_ASU],
      win_[0], 10,     (t3>>1)+t2+160, (t1*3)-20,  (t3/6)-8, &gc_[W_ASU],
        black, light_grey, 3);
    open_daughter_window (&button_[W_IMU],
      win_[0], 10, ((t3<<1)/3)+t2+160, (t1*3)-20,  (t3/6)-8, &gc_[W_IMU],
        black, light_grey, 3);
    open_daughter_window (&button_[W_IDU],
      win_[0], 10,  ((t3*5)/6)+t2+160, (t1*3)-20,  (t3/6)-8, &gc_[W_IDU],
        black, light_grey, 3);

    /* memory-LSU, memory-fetcher */
    main_segments[0].x1=main_segments[0].x2=(t1*3)>>1;
    main_segments[1].x1=main_segments[1].x2=(t1*15)>>1;
    main_segments[0].y1=main_segments[1].y1=100;
    main_segments[0].y2=main_segments[1].y2=130;

    /* fetcher -> tags + decoder */
    main_segments[6].y1=main_segments[7].y1=
    main_segments[2].y2=main_segments[3].y2=main_segments[4].y2=t2+120;
    main_segments[2].y1=main_segments[3].y1=main_segments[5].y1=main_segments[5].y2=t2+140;
    main_segments[6].y2=main_segments[7].y2=main_segments[4].y1=t2+160;
    main_segments[2].x1=main_segments[2].x2=main_segments[5].x1=(t1*7)>>1;
    main_segments[3].x1=main_segments[3].x2=(t1*11)>>1;
    main_segments[4].x1=main_segments[4].x2=main_segments[5].x2=(t1*15)>>1;

    /* TLB->tags */
    main_segments[6].x1=main_segments[6].x2=main_segments[5].x1+12;
    main_segments[7].x1=main_segments[7].x2=main_segments[3].x1+12;

    /* Fetcher-Xbar */
    main_segments[8].x1=main_segments[8].x2=main_segments[9].x1=(t1*6)+10;
    main_segments[9].x2=main_segments[18].x1=main_segments[18].x2=(t1*5)+13;
    main_segments[8].y1=t2+140;
    main_segments[18].y1=(t2<<1)+180;
    main_segments[18].y2=main_segments[8].y2=
     main_segments[9].y1=main_segments[9].y2=(t2*2)+160;

    /* LSU-Xbar */
    main_segments[19].y1=(t2*2)+180;
    main_segments[20].x1=main_segments[19].x1=main_segments[19].x2=(t1*4)+27;
    main_segments[21].y1=main_segments[20].y1=main_segments[20].y2=main_segments[19].y2=(t2*2)+160;
    main_segments[22].x1=main_segments[21].x1=main_segments[21].x2=main_segments[20].x2=(t1*3)+10;
    main_segments[23].y1=main_segments[22].y1=main_segments[22].y2=main_segments[21].y2=t2+140;
    main_segments[23].x1=main_segments[23].x2=main_segments[22].x2=(t1*3)>>1;
    main_segments[23].y2=t2+120;

    /* Xbar-R7 */
    for (i=1; i<8; i++) {
      main_segments[i+9].y1=main_segments[i+9].y2=((i*(t2+10))/6)+(t2*3)+140;
      main_segments[i+9].x1=(t1*5)+20;
      main_segments[i+9].x2=(t1*6)+30;
    }
    /* + Xbar-SR */
    main_segments[15].y1=main_segments[15].y2=(t2*4)+160+((t2-30)/3);
    main_segments[16].y1=main_segments[16].y2=(t2*4)+160+(((t2-30)*2)/3);

    /* TLB-Xbar */
    main_segments[17].x1=main_segments[17].x2=(xsize_[0]+20)>>1;
    main_segments[17].y1=(t2<<1)+140;
    main_segments[17].y2=(t2*2)+180;

    for (i=1; i<7; i++) {
      main_segments[i+23].x1=(t1*4)+20;
      main_segments[i+23].x2=(t1*3)-10;
      main_segments[i+23].y1=(t2*2)+180+((i* ((t2*3)-50))/7);
      main_segments[i+23].y2=t2+160-(t3/12)+((i*t3)/6);
    }
  }


  /* create the other windows... */
  for (i=1; i<W_LAST; i++)
    if (resize_flag & 1L<<i) {
      /* size fixup : */
      if (xsize_[i]<200) {
        xsize_[i]=200;
      }
      if (ysize_[i]<200) {
        ysize_[i]=200;
      }
      /* opens the main window */
      open_window(&win_[i],xsize_[i], ysize_[i],&gc_[i],black,grey,window_names[i],hide_[i]);
      /* create the "hide" button */
      open_daughter_window (&button_hide_[i], win_[i],  10, 10, 45, 17, &gc_[i], black, light_grey, 1);
    }

  resize_flag=0;

  /* main loop */  

  do {
    XNextEvent(dpy,&event);
    switch(event.type) {

      case Expose:
        if (event.xexpose.window==button_quit){
          XDrawImageString(dpy,button_quit,gc1,3,13,"QUIT",4);
	} else if (event.xexpose.window==button_init) {
          XDrawImageString(dpy,button_init,gc2,5,13,"INIT",4);
	} else if (event.xexpose.window==button_step) {
          XDrawImageString(dpy,button_step,gc3,3,13,"STEP",4);
	} else if (event.xexpose.window==button_[W_mem]) {
          XDrawImageString(dpy,button_[W_mem],gc_[W_mem],
                 ((xsize_[0]-(26*2))-52)>>1,(50+12)>>1,"MEMORY",6);
	} else if (event.xexpose.window==win_[0]) {
          XDrawSegments(dpy,win_[0],gc_[0],main_segments,
                 sizeof(main_segments)/sizeof(XSegment));
	} else if (event.xexpose.window==button_[W_LSU]) {
          XDrawImageString(dpy,button_[W_LSU],gc_[W_LSU],
                 ((t1*3)-30)>>1,t2>>1,"LSU",3);
	} else if (event.xexpose.window==button_[W_LSU_tags]) {
          XDrawImageString(dpy,button_[W_LSU_tags],gc_[W_LSU_tags],
                 ((t1)-30)>>1,t2>>1,"tags",4);
	} else if (event.xexpose.window==button_[W_fetch_logic]) {
          XDrawImageString(dpy,button_[W_fetch_logic],gc_[W_fetch_logic],
                 ((t1)-25)>>1,(t2>>1)-8,"Bus",3);
          XDrawImageString(dpy,button_[W_fetch_logic],gc_[W_fetch_logic],
                 ((t1)-45)>>1,(t2>>1)+8,"Arbiter",7);
	} else if (event.xexpose.window==button_[W_fetcher_tags]) {
          XDrawImageString(dpy,button_[W_fetcher_tags],gc_[W_fetcher_tags],
                 ((t1)-30)>>1,t2>>1,"tags",4);
	} else if (event.xexpose.window==button_[W_fetcher]) {
          XDrawImageString(dpy,button_[W_fetcher],gc_[W_fetcher],
                 ((t1*3)-70)>>1,t2>>1,"FETCHER",7);
	} else if (event.xexpose.window==button_[W_Xbar]) {
          XDrawImageString(dpy,button_[W_Xbar],gc_[W_Xbar],
                 (t1-30)>>1,((t2*3)>>1)-20,"Xbar",4);
	} else if (event.xexpose.window==button_[W_TLB]) {
          XDrawImageString(dpy,button_[W_TLB],gc_[W_TLB],
                 (xsize_[0]>>3)-15,(t2>>1)-6,"TLB",3);
	} else if (event.xexpose.window==button_[W_decoder]) {
          XDrawImageString(dpy,button_[W_decoder],gc_[W_decoder],
                 (xsize_[0]>>3)-25,t2>>1,"Decoder",7);
	} else if (event.xexpose.window==button_[W_scoreboard]) {
          XDrawImageString(dpy,button_[W_scoreboard],gc_[W_scoreboard],
                 (xsize_[0]>>3)-35,(t2>>1)-10,"Scoreboard",10);
	} else if (event.xexpose.window==button_[W_register]) {
          XDrawImageString(dpy,button_[W_register],gc_[W_register],
                 (xsize_[0]>>3)-45,(t2>>1)+10,"REGISTERS",9);
	} else if (event.xexpose.window==button_[W_SR]) {
          XDrawImageString(dpy,button_[W_SR],gc_[W_SR],
                 (xsize_[0]>>3)-50,(t2>>1)-10,"Special Registers",17);
	} else if (event.xexpose.window==button_[W_ROP2]) {
          XDrawImageString(dpy,button_[W_ROP2],gc_[W_ROP2],
                 (xsize_[0]>>3)-40,(t3/12)+1,"ROP2",4);
	} else if (event.xexpose.window==button_[W_INC]) {
          XDrawImageString(dpy,button_[W_INC],gc_[W_INC],
                 (xsize_[0]>>3)-40,(t3/12)+1,"INC/SORT",8);
	} else if (event.xexpose.window==button_[W_SHUFFLER]) {
          XDrawImageString(dpy,button_[W_SHUFFLER],gc_[W_SHUFFLER],
                 (xsize_[0]>>3)-40,(t3/12)+1,"SHUFFLER",8);
	} else if (event.xexpose.window==button_[W_ASU]) {
          XDrawImageString(dpy,button_[W_ASU],gc_[W_ASU],
                 (xsize_[0]>>3)-40,(t3/12)+1,"ADD/SUB",7);
	} else if (event.xexpose.window==button_[W_IMU]) {
          XDrawImageString(dpy,button_[W_IMU],gc_[W_IMU],
                 (xsize_[0]>>3)-40,(t3/12)+1,"MULTIPLY",8);
	} else if (event.xexpose.window==button_[W_IDU]) {
          XDrawImageString(dpy,button_[W_IDU],gc_[W_IDU],
                 (xsize_[0]>>3)-40,(t3/12)+1,"DIVIDE",6);
	} else
	  for (i=1; i<W_LAST; i++)
	    if (event.xexpose.window==button_hide_[i]) {
              XDrawImageString(dpy,button_hide_[i],gc_[i],3,13,"HIDE",4);
	      break;
	    }

        break;

      case ButtonPress:

	/* left button only */
	if (event.xbutton.button==1) {

	  for (i=1; i<W_LAST; i++)
	    if ((event.xbutton.window==button_[i])
	      ||(event.xbutton.window==button_hide_[i])) {
              if (hide_[i]==HIDDEN) {
                hide_[i]=SHOWN;
                XMapWindow (dpy, win_[i]);
	      }
	      else {
                hide_[i]=HIDDEN;
                XUnmapWindow (dpy, win_[i]);
	      }
              break;
	    }
	}
        break;

      case MotionNotify: /* for the eventual scrollbars */

        break;

      case ResizeRequest:
        resize_flag=0;
	for (i=0; i<W_LAST; i++)
	  if (event.xresizerequest.window==win_[i]) {
	    resize_flag=1L<<i;
	    xsize_[i]=event.xresizerequest.width;
	    ysize_[i]=event.xresizerequest.height;
	    break;
	  }
        break;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;
        break;

    }
  } while (!(((event.type==ButtonRelease)&&(event.xexpose.window==button_quit))
            ||(resize_flag!=0)));

the_end:

  if (resize_flag==0) {
    /* collect the X geometries of the windows and save them to a file */
  }

  for (i=0; i<W_LAST; i++)
    if ((resize_flag == (1L<<i))||(resize_flag==0)) {
      close_window(&win_[i]);
      if (resize_flag)
        goto redisplay;
    }

  exitX();
}
