;;; *** move ***

(define_insn "movdi"
   [(set (match_operand:DI 0 "general_operand" "=r,r,m,r,m,r,r")
         (match_operand:DI 1 "general_operand"  "r,m,r,N,N,I,i"))]
   ""
   "@
    mov64\\t%1, %0
    load64\\t%1, %0
    store64\\t%1, %0
    mov64\\tr0, %0
    store64\\tr0, %0
    loadcst\\t%1, %0
    UNSUPPORTED move(DI) %1 to %0")

(define_insn "movsi"
   [(set (match_operand:SI 0 "general_operand" "=r,r,m,r,m,r,r")
         (match_operand:SI 1 "general_operand"  "r,m,r,N,N,I,i"))]
   ""
   "@
    mov32\\t%1, %0
    load32\\t%1, %0
    store32\\t%1, %0
    mov32\\tr0, %0
    store32\\tr0, %0
    loadcst\\t%1, %0
    UNSUPPORTED move(SI) %1 to %0")

(define_insn "movhi"
   [(set (match_operand:HI 0 "general_operand" "=r,r,m,r,m,r")
         (match_operand:HI 1 "general_operand"  "r,m,r,N,N,I"))]
   ""
   "@
    mov16\\t%1, %0
    load16\\t%1, %0
    store16\\t%1, %0
    mov16\\tr0, %0
    store16\\tr0, %0
    loadcst\\t%1, %0")

(define_insn "movqi"
   [(set (match_operand:QI 0 "general_operand" "=r,r,m,r,m,r")
         (match_operand:QI 1 "general_operand"  "r,m,r,N,N,I"))]
   ""
   "@
    mov8\\t%1, %0
    load8\\t%1, %0
    store8\\t%1, %0
    mov8\\tr0, %0
    store8\\tr0, %0
    loadcst\\t%1, %0")

(define_insn "movdf"
   [(set (match_operand:DF 0 "general_operand" "=r,r,m")
         (match_operand:DF 1 "general_operand"  "r,m,r"))]
   ""
   "@
    mov64\\t%1, %0
    load64\\t%1, %0
    store64\\t%1, %0")

(define_insn "movsf"
   [(set (match_operand:SF 0 "general_operand" "=r,r,m")
         (match_operand:SF 1 "general_operand"  "r,m,r"))]
   ""
   "@
    mov32\\t%1, %0
    load32\\t%1, %0
    store32\\t%1, %0")

;;; *** arithmetic shift left ***

(define_insn "ashldi3"
   [(set (match_operand:DI 0 "register_operand" "=r,r")
         (ashift:DI (match_operand:DI 1 "register_operand" "r,r")
                    (match_operand:DI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftl64\\t%2, %1, %0
    shiftli64\\t%2, %1, %0")

(define_insn "ashlsi3"
   [(set (match_operand:SI 0 "register_operand" "=r,r")
         (ashift:SI (match_operand:SI 1 "register_operand" "r,r")
                    (match_operand:SI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftl32\\t%2, %1, %0
    shiftli32\\t%2, %1, %0")

(define_insn "ashlhi3"
   [(set (match_operand:HI 0 "register_operand" "=r,r")
         (ashift:HI (match_operand:HI 1 "register_operand" "r,r")
                    (match_operand:HI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftl16\\t%2, %1, %0
    shiftli16\\t%2, %1, %0")

(define_insn "ashlqi3"
   [(set (match_operand:QI 0 "register_operand" "=r,r")
         (ashift:QI (match_operand:QI 1 "register_operand" "r,r")
                    (match_operand:QI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftl8\\t%2, %1, %0
    shiftli8\\t%2, %1, %0")

;;; *** arithmetic shift right ***

(define_insn "ashrdi3"
   [(set (match_operand:DI 0 "register_operand" "=r,r")
         (ashiftrt:DI (match_operand:DI 1 "register_operand" "r,r")
                      (match_operand:DI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftra64\\t%2, %1, %0
    shiftrai64\\t%2, %1, %0")

(define_insn "ashrsi3"
   [(set (match_operand:SI 0 "register_operand" "=r,r")
         (ashiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
                      (match_operand:SI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftra32\\t%2, %1, %0
    shiftrai32\\t%2, %1, %0")

(define_insn "ashrhi3"
   [(set (match_operand:HI 0 "register_operand" "=r,r")
         (ashiftrt:HI (match_operand:HI 1 "register_operand" "r,r")
                      (match_operand:HI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftra16\\t%2, %1, %0
    shiftrai16\\t%2, %1, %0")

(define_insn "ashrqi3"
   [(set (match_operand:QI 0 "register_operand" "=r,r")
         (ashiftrt:QI (match_operand:QI 1 "register_operand" "r,r")
                      (match_operand:QI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftra8\\t%2, %1, %0
    shiftrai8\\t%2, %1, %0")

;;; *** logical shift right ***

(define_insn "lshrdi3"
   [(set (match_operand:DI 0 "register_operand" "=r,r")
         (lshiftrt:DI (match_operand:DI 1 "register_operand" "r,r")
                      (match_operand:DI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftr\\t%2, %1, %0
    shiftri\\t%2, %1, %0")

(define_insn "lshrsi3"
   [(set (match_operand:SI 0 "register_operand" "=r,r")
         (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
                      (match_operand:SI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftr32\\t%2, %1, %0
    shiftri32\\t%2, %1, %0")

(define_insn "lshrhi3"
   [(set (match_operand:HI 0 "register_operand" "=r,r")
         (lshiftrt:HI (match_operand:HI 1 "register_operand" "r,r")
                      (match_operand:HI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftr16\\t%2, %1, %0
    shiftri16\\t%2, %1, %0")

(define_insn "lshrqi3"
   [(set (match_operand:QI 0 "register_operand" "=r,r")
         (lshiftrt:QI (match_operand:QI 1 "register_operand" "r,r")
                      (match_operand:QI 2 "general_operand"  "r,L")))]
   ""
   "@
    shiftr8\\t%2, %1, %0
    shiftri8\\t%2, %1, %0")

;;; *** and ***

(define_insn "anddi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r")
          (and:DI (match_operand:DI 1 "register_operand" "%r,r")
                  (match_operand:DI 2 "general_operand"   "r,L")))]
    ""
    "@
     and64\\t%2, %1, %0
     andi64\\t%2, %1, %0")

(define_insn "andsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r")
          (and:SI (match_operand:SI 1 "register_operand" "%r,r")
                  (match_operand:SI 2 "general_operand"   "r,L")))]
    ""
    "@
     and32\\t%2, %1, %0
     andi32\\t%2, %1, %0")

(define_insn "andhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r")
          (and:HI (match_operand:HI 1 "register_operand" "%r,r")
                  (match_operand:HI 2 "general_operand"   "r,L")))]
    ""
    "@
     and16\\t%2, %1, %0
     andi16\\t%2, %1, %0")

(define_insn "andqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r")
          (and:QI (match_operand:QI 1 "register_operand" "%r,r")
                  (match_operand:QI 2 "general_operand"   "r,L")))]
    ""
    "@
     and8\\t%2, %1, %0
     andi8\\t%2, %1, %0")

;;; *** or ***

(define_insn "iordi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r")
          (ior:DI (match_operand:DI 1 "register_operand" "%r,r")
                  (match_operand:DI 2 "general_operand"   "r,L")))]
    ""
    "@
     or64\\t%2, %1, %0
     ori64\\t%2, %1, %0")   

(define_insn "iorsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r")
          (ior:SI (match_operand:SI 1 "register_operand" "%r,r")
                  (match_operand:SI 2 "general_operand"   "r,L")))]
    ""
    "@
     or32\\t%2, %1, %0
     ori32\\t%2, %1, %0")

(define_insn "iorhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r")
          (ior:HI (match_operand:HI 1 "register_operand" "%r,r")
                  (match_operand:HI 2 "general_operand"   "r,L")))]
    ""
    "@
     or16\\t%2, %1, %0
     ori16\\t%2, %1, %0")

(define_insn "iorqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r")
          (ior:QI (match_operand:QI 1 "register_operand" "%r,r")
                  (match_operand:QI 2 "general_operand"   "r,L")))]
    ""
    "@
     or8\\t%2, %1, %0
     ori8\\t%2, %1, %0")


;;; *** exclusive or ***
    
(define_insn "xordi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r")
          (xor:DI (match_operand:DI 1 "register_operand" "%r,r")
                  (match_operand:DI 2 "general_operand"   "r,L")))]
    ""
    "@
     xor64\\t%2, %1, %0
     xori64\\t%2, %1, %0")   

(define_insn "xorsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r")
          (xor:SI (match_operand:SI 1 "register_operand" "%r,r")
                  (match_operand:SI 2 "general_operand"   "r,L")))]
    ""
    "@
     xor32\\t%2, %1, %0
     xori32\\t%2, %1, %0")

(define_insn "xorhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r")
          (xor:HI (match_operand:HI 1 "register_operand" "%r,r")
                  (match_operand:HI 2 "general_operand"   "r,L")))]
    ""
    "@
     xor16\\t%2, %1, %0
     xori16\\t%2, %1, %0")

(define_insn "xorqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r")
          (xor:QI (match_operand:QI 1 "register_operand" "%r,r")
                  (match_operand:QI 2 "general_operand"   "r,L")))]
    ""
    "@
     xor8\\t%2, %1, %0
     xori8\\t%2, %1, %0")

;;; *** negation ***

(define_insn "negdi2"
    [(set (match_operand:DI 0 "register_operand" "=r")
          (neg:DI (match_operand:DI 1 "register_operand" "r")))]
    ""
    "neg64\\t%1, %0")

(define_insn "negsi2"
    [(set (match_operand:SI 0 "register_operand" "=r")
          (neg:SI (match_operand:SI 1 "register_operand" "r")))]
    ""
    "neg32\\t%1, %0")

(define_insn "neghi2"
    [(set (match_operand:HI 0 "register_operand" "=r")
          (neg:HI (match_operand:HI 1 "register_operand" "r")))]
    ""
    "neg16\\t%1, %0")

(define_insn "negqi2"
    [(set (match_operand:QI 0 "register_operand" "=r")
          (neg:QI (match_operand:QI 1 "register_operand" "r")))]
    ""
    "neg8\\t%1, %0")
		      
;;; *** addition ***

(define_insn "adddf3"
    [(set (match_operand:DF 0 "register_operand" "=r")
          (plus:DF (match_operand:DF 1 "register_operand" "%r")
                   (match_operand:DF 2 "register_operand" "r")))]
    ""
    "fadd64\\t%2, %1, %0")

(define_insn "addsf3"
    [(set (match_operand:SF 0 "register_operand" "=r")
          (plus:SF (match_operand:SF 1 "register_operand" "%r")
                   (match_operand:SF 2 "register_operand" "r")))]
    ""
    "fadd32\\t%2, %1, %0")

(define_insn "adddi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r,r")
          (plus:DI (match_operand:DI 1 "register_operand" "%r,r,r")
                   (match_operand:DI 2 "general_operand"   "r,O,L")))]
    ""
    "@
     add64\\t%2, %1, %0
     inc64\\t%1, %0
     addi64\\t%2, %1, %0")

(define_insn "addsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r,r")
          (plus:SI (match_operand:SI 1 "register_operand" "%r,r,r")
                   (match_operand:SI 2 "general_operand"   "r,O,L")))]
    ""
    "@
     add32\\t%2, %1, %0
     inc32\\t%1, %0
     addi32\\t%2, %1, %0")

(define_insn "addhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r,r")
          (plus:HI (match_operand:HI 1 "register_operand" "%r,r,r")
                   (match_operand:HI 2 "general_operand"   "r,O,L")))]
    ""
    "@
     add16\\t%2, %1, %0
     inc16\\t%1, %0
     addi16\\t%2, %1, %0")

(define_insn "addqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r,r")
          (plus:QI (match_operand:QI 1 "register_operand" "%r,r,r")
                   (match_operand:QI 2 "general_operand"   "r,O,L")))]
    ""
    "@
     add8\\t%2, %1, %0
     inc8\\t%1, %0
     addi8\\t%2, %1, %0")

;;; *** subtraction ***

(define_insn "subdf3"
    [(set (match_operand:DF 0 "register_operand" "=r")
          (minus:DF (match_operand:DF 1 "register_operand" "r")
                    (match_operand:DF 2 "register_operand" "r")))]
    ""
    "fsub64\\t%2, %1, %0")

(define_insn "subsf3"
    [(set (match_operand:SF 0 "register_operand" "=r")
          (minus:SF (match_operand:SF 1 "register_operand" "r")
                    (match_operand:SF 2 "register_operand" "r")))]
    ""
    "fsub32\\t%2, %1, %0")

(define_insn "subdi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r,r")
          (minus:DI (match_operand:DI 1 "register_operand" "r,r,r")
                    (match_operand:DI 2 "general_operand"  "r,O,L")))]
    ""
    "@
     sub64\\t%2, %1, %0
     dec64\\t%1, %0
     subi64\\t%2, %1, %0")

(define_insn "subsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r,r")
          (minus:SI (match_operand:SI 1 "register_operand" "r,r,r")
                    (match_operand:SI 2 "general_operand"  "r,O,L")))]
    ""
    "@
     sub32\\t%2, %1, %0
     dec32\\t%1, %0
     subi32\\t%2, %1, %0")

(define_insn "subhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r,r")
          (minus:HI (match_operand:HI 1 "register_operand" "r,r,r")
                    (match_operand:HI 2 "general_operand"  "r,O,L")))]
    ""
    "@
     sub16\\t%2, %1, %0
     dec16\\t%1, %0
     subi16\\t%2, %1, %0")

(define_insn "subqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r,r")
          (minus:QI (match_operand:QI 1 "register_operand" "r,r,r")
                    (match_operand:QI 2 "general_operand"  "r,O,L")))]
    ""
    "@
     sub8\\t%2, %1, %0
     dec8\\t%1, %0
     subi8\\t%2, %1, %0")

;;; *** multiplication ***

(define_insn "muldf3"
    [(set (match_operand:DF 0 "register_operand" "=r")
          (mult:DF (match_operand:DF 1 "register_operand" "%r")
                   (match_operand:DF 2 "register_operand" "r")))]
    ""
    "fmul64\\t%2, %1, %0")

(define_insn "multsf3"
    [(set (match_operand:SF 0 "register_operand" "=r")
          (mult:SF (match_operand:SF 1 "register_operand" "%r")
                   (match_operand:SF 2 "register_operand" "r")))]
    ""
    "fmul32\\t%2, %1, %0")

(define_insn "muldi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r")
          (mult:DI (match_operand:DI 1 "register_operand" "%r,r")
                   (match_operand:DI 2 "general_operand"   "r,K")))]
    ""
    "@
     mul64\\t%2, %1, %0
     muli64\\t%2, %1, %0")

(define_insn "mulsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r")
          (mult:SI (match_operand:SI 1 "register_operand" "%r,r")
                   (match_operand:SI 2 "general_operand"   "r,K")))]
    ""
    "@
     mul32\\t%2, %1, %0
     muli32\\t%2, %1, %0")

(define_insn "mulhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r")
          (mult:HI (match_operand:HI 1 "register_operand" "%r,r")
                   (match_operand:HI 2 "general_operand"   "r,K")))]
    ""
    "@
     mul16\\t%2, %1, %0
     muli16\\t%2, %1, %0")

(define_insn "mulqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r")
          (mult:QI (match_operand:QI 1 "register_operand" "%r,r")
                   (match_operand:QI 2 "general_operand"   "r,K")))]
    ""
    "@
     mul8\\t%2, %1, %0
     muli8\\t%2, %1, %0")

;;; *** division ***

(define_insn "divdf3"
    [(set (match_operand:DF 0 "register_operand" "=r")
          (div:DF (match_operand:DF 1 "register_operand" "%r")
                  (match_operand:DF 2 "register_operand" "r")))]
    ""
    "fdiv64\\t%2, %1, %0")

(define_insn "divsf3"
    [(set (match_operand:SF 0 "register_operand" "=r")
          (div:SF (match_operand:SF 1 "register_operand" "%r")
                  (match_operand:SF 2 "register_operand" "r")))]
    ""
    "fdiv32\\t%2, %1, %0")

(define_insn "divdi3"
    [(set (match_operand:DI 0 "register_operand" "=r,r")
          (div:DI (match_operand:DI 1 "register_operand" "r,r")
                  (match_operand:DI 2 "general_operand"  "r,K")))]
    ""
    "@
     div64.s\\t%2, %1, %0
     divi64.s\\t%2, %1, %0")

(define_insn "divsi3"
    [(set (match_operand:SI 0 "register_operand" "=r,r")
          (div:SI (match_operand:SI 1 "register_operand" "r,r")
                  (match_operand:SI 2 "general_operand"  "r,K")))]
    ""
    "@
     div32.s\\t%2, %1, %0
     divi32.s\\t%2, %1, %0")

(define_insn "divhi3"
    [(set (match_operand:HI 0 "register_operand" "=r,r")
          (div:HI (match_operand:HI 1 "register_operand" "r,r")
                  (match_operand:HI 2 "general_operand"  "r,K")))]
    ""
    "@
     div16.s\\t%2, %1, %0
     divi16.s\\t%2, %1, %0")

(define_insn "divqi3"
    [(set (match_operand:QI 0 "register_operand" "=r,r")
          (div:QI (match_operand:QI 1 "register_operand" "r,r")
                  (match_operand:QI 2 "general_operand"  "r,K")))]
    ""
    "@
     div8.s\\t%2, %1, %0
     divi8.s\\t%2, %1, %0")

;;; *** unsigned division ***

(define_insn "udivdi3"
    [(set (match_operand:DI 0 "register_operand" "=r")
          (udiv:DI (match_operand:DI 1 "register_operand" "r")
                   (match_operand:DI 2 "register_operand" "r")))]
    ""
    "div64\\t%2, %1, %0")

(define_insn "udivsi3"
    [(set (match_operand:SI 0 "register_operand" "=r")
          (udiv:SI (match_operand:SI 1 "register_operand" "r")
                   (match_operand:SI 2 "register_operand" "r")))]
    ""
    "div32\\t%2, %1, %0")

(define_insn "udivhi3"
    [(set (match_operand:HI 0 "register_operand" "=r")
          (udiv:HI (match_operand:HI 1 "register_operand" "r")
                   (match_operand:HI 2 "register_operand" "r")))]
    ""
    "div16\\t%2, %1, %0")

(define_insn "udivqi3"
    [(set (match_operand:QI 0 "register_operand" "=r")
          (udiv:QI (match_operand:QI 1 "register_operand" "r")
                   (match_operand:QI 2 "register_operand" "r")))]
    ""
    "div8\\t%2, %1, %0")

;;; *** truncation ***

(define_insn "truncdfsf2"
    [(set (match_operand:SF 0 "register_operand" "=r")
          (truncate:SF (match_operand:DF 1 "register_operand" "r")))]
    ""
    "ftrunc32\\t%1, %0")

;;; *** extension ***

(define_insn "extendsfdf2"
    [(set (match_operand:DF 0 "register_operand" "=r")
          (sign_extend:DF (match_operand:SF 1 "register_operand" "r")))]
    ""
    "fext32\\t%1, %0")

(define_insn "extendsidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
         (sign_extend:DI (match_operand:SI 1 "register_operand" "r")))]
   ""
   "sex32\\t%1, %0")

(define_insn "extendhidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
         (sign_extend:DI (match_operand:HI 1 "register_operand" "r")))]
   ""
   "sex16\\t%1, %0")

(define_insn "extendqidi2"
   [(set (match_operand:DI 0 "register_operand" "=r")
         (sign_extend:DI (match_operand:QI 1 "register_operand" "r")))]
   ""
   "sex8\\t%1, %0")

;;; *** jumping ***

(define_insn "jump"
   [(set (pc)
         (label_ref (match_operand 0 "" "")))]
   ""
   "jmpi\\t%l0")

(define_insn "indirect_jump"
   [(set (pc) 
   	 (match_operand:DI 0 "register_operand" "r"))]
   ""
   "jmpa\\t%0")

;;; *** calling ***

;;(define_insn "call"
;;  [(call (mem:DI (match_operand:DI 0 "register_operand" "r"))
;;         (match_operand    1 "immediate_operand" "i"))
;;   (clobber (match_operand:DI 2 "register_operand" "=r"))]
;;  ""
;;  "lpe\\t8, r60
;;   jmpa %2")

;;(define_insn "call_value"
;;  [(set (match_operand:DI 0 "register_operand" "=r")
;;        (call (mem:DI (match_operand:DI 1 "register_operand" "r"))
;;	      (match_operand    2 "immediate_operand" "i")))
;;   (clobber (match_operand:DI 3 "register_operand" "=r"))]
;;  ""
;;  "lpe\\t8, r60
;;   jmpa\\t%3
;;   mov\\tr59, %0")
				  
(define_insn "call"
   [(call (match_operand:DI 0 "memory_operand" "m")
         (match_operand    1 "immediate_operand" "i"))]
   ""
   "lpe\\t8, r60
    \\tjmpa\\t%0")

(define_insn "call_value"
   [(set (match_operand 0 "register_operand" "=r")
         (call (match_operand:DI 1 "memory_operand" "m")
	       (match_operand    2 "immediate_operand" "i")))]
   ""
   "lpe\\t8, r60
    \\tjmpa\\t%1 
    \\tmov\\tr59, %0")

;;; *** comparison ***

(define_insn "cmpdi"
  [(set (cc0)
        (compare (match_operand:DI 0 "register_operand" "r")
                 (match_operand:DI 1 "general_operand" "rm")))]
  ""
  "* return cmp_ops (DImode, operands);")

(define_insn "cmpdf"
  [(set (cc0)
        (compare (match_operand:DF 0 "register_operand" "r")
                 (match_operand:DF 1 "general_operand" "rm")))]
  ""
  "* return cmp_ops (DFmode, operands);")

(define_insn "cmpsf"
  [(set (cc0)
        (compare (match_operand:SF 0 "register_operand" "r")
                 (match_operand:SF 1 "general_operand" "rm")))]
  ""
  "* return cmp_ops (SFmode, operands);")

;;; *** branching ***

(define_insn "beq"
  [(set (pc)
        (if_then_else (eq (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"\", 2, operands[0]); ")

(define_insn "bne"
  [(set (pc)
        (if_then_else (ne (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"\", 8, operands[0]); ")

(define_insn "bgt"
  [(set (pc)
        (if_then_else (gt (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"\", 0, operands[0]); ")

(define_insn "bgtu"
  [(set (pc)
        (if_then_else (gtu (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"u\", 0, operands[0]); ")

(define_insn "blt"
  [(set (pc)
        (if_then_else (lt (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"\", 6, operands[0]); ")

(define_insn "bltu"
  [(set (pc)
        (if_then_else (ltu (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"u\", 6, operands[0]); ")

(define_insn "bge"
  [(set (pc)
        (if_then_else (ge (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"\", 4, operands[0]); ")

(define_insn "bgeu"
  [(set (pc)
        (if_then_else (geu (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"u\", 4, operands[0]); ")

(define_insn "ble"
  [(set (pc)
        (if_then_else (le (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"\", 10, operands[0]); ")

(define_insn "bleu"
  [(set (pc)
        (if_then_else (leu (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return cmp_jmp(\"u\", 10, operands[0]); ")

;;; *** miscellaneous ***

(define_insn "nop"
    [(const_int 0)]
    ""
    "nop")

