/* Subroutines for insn-output.c for GNU compiler.  Elxsi version.
   Copyright (C) 1987, 1992, 1997 Free Software Foundation, Inc
   This port, done by Mike Stump <mrs@cygnus.com> in 1988, and is the first
   64 bit port of GNU CC.
   Based upon the VAX port.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "config.h"
#include <stdio.h>
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "insn-flags.h"
#include "output.h"
#include "insn-attr.h"
#include "flags.h"
#include "recog.h"
#include "reload.h"
#include "tree.h"
#include "expr.h"
#include "obstack.h"
#include "except.h"
#include "function.h"
#include "toplev.h"
#include "fcpu.h"

/* If non-null, this rtx holds the return address for the function.  */

static rtx fcpu_return_addr_rtx;
extern char *reg_names[];
rtx cmp_op0=0, cmp_op1=0;
enum machine_mode cmp_mode;

/* table of relations for compares and branches */
char *cmp_tab[] = {
    "gt", "gt", "eq", "eq", "ge", "ge", "lt", "lt", "ne", "ne",
    "le", "le" };

char *cmp_ops (enum machine_mode mode, rtx * ops)
{
    cmp_op0  = ops [0];
    cmp_op1  = ops [1];
    cmp_mode = mode;
    return "";
}

/* type is the index into the above table */
/* s is "" for signed, or "u" for unsigned */
char *cmp_jmp(s, type, where) char *s; rtx where; {
    rtx br_ops[3];
    char template[50];
    char *f = "";
    char *bits = "64";
    if (GET_MODE (cmp_op0) == SFmode) f = "f", bits = "32";
    if (GET_MODE (cmp_op0) == DFmode) f = "f";
    br_ops[0] = where;
    br_ops[1] = cmp_op0;
    br_ops[2] = cmp_op1;
    if (cmp_op1)
	sprintf(template, "%scmp%s%s\t%%1, %%2\n\tj%s\t%%l0",
		f, s, bits, cmp_tab[type]);
    else if (*f)
	sprintf(template, "fcmp%s\t%%1, 0\n\tj%s\t%%l0",
		bits, cmp_tab[type]);
    else if (*s) /* can turn the below in to a jmp ... */
	sprintf(template, "cmp64u\t%%1, 0\n\tj%s\t%%l0", s, cmp_tab[type]);
    else
	sprintf(template, "jmp%s\t%%1, %%l0", cmp_tab[type+1]);
    output_asm_insn(template, br_ops);
    return "";
}

char *cmp_set(s, type, reg) char *s, *type; rtx reg; {
    rtx br_ops[3];
    char template[50];
    char *f = "";
    char *bits = "64";
    if (GET_MODE (cmp_op0) == SFmode) f = "f", bits = "32";
    else if (GET_MODE (cmp_op0) == DFmode) f = "f";
    else if (GET_MODE (cmp_op0) == SImode) bits = "32";
    else if (GET_MODE (cmp_op0) == HImode) bits = "16";
    else if (GET_MODE (cmp_op0) == QImode) bits = "8";
    br_ops[0] = reg;
    br_ops[1] = cmp_op0;
    br_ops[2] = cmp_op1;
    if (cmp_op1)
	sprintf(template, "%scmp%s.%s\t%%0, %%1,%%2:%s",
		f, s, bits, type);
    else
	sprintf(template, "%scmp%s.%s\t%%0, %%1,0:%s",
		f, s, bits, type);
    output_asm_insn(template, br_ops);
    return "";
}

void function_prologue (FILE * file, int size)
{
   extern char   call_used_regs [];
   extern char * reg_names [];

   int regno, saved;
  
   for (regno = 0, saved = 0;
	regno < FIRST_PSEUDO_REGISTER;
	++ regno)
   if (regs_ever_live [regno] &&
       ! call_used_regs [regno])
     ++ saved;

   if (saved <= 0)
   {
     if (size > 0)
       fprintf (file, "\tsubi\t%d, r63, r63\n", size);
     return;
   }

   fprintf (file, "\tsubi\t8, r63, r63\n");

   for (regno = 0;
        saved > 1;
        -- saved, ++ regno)
   {
      while (! regs_ever_live [regno] ||
             call_used_regs [regno])
         ++ regno;
      fprintf (file, "\tstorei\t-8, r63, %s\n", reg_names [regno]);
   }

   while (! regs_ever_live [regno] ||
	  call_used_regs [regno])
      ++ regno;
   
   if (size > 0)
     fprintf (file, "\tstorei\t-%d, r63, %s\n", size, reg_names [regno]);
   else
     fprintf (file, "\tstore\tr63, %s\n", reg_names [regno]);
}

void function_epilogue (FILE * file, int size)
{
   extern char   call_used_regs [];
   extern char * reg_names [];

   int regno;

   if (size > 0)
     fprintf (file, "\taddi\t%d, r63, r63\n", size);
   
   for (regno = 0;
        regno < FIRST_PSEUDO_REGISTER;
        ++ regno)
   if (regs_ever_live [regno] &&
       ! call_used_regs [regno])
     fprintf (file, "\tloadi\t8, r63, %s\n", reg_names [regno]);
}
   
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
  register rtx reg1, reg2, breg, ireg;
  rtx offset;

 retry:
  switch (GET_CODE (addr))
    {

    case MEM:
      if (GET_CODE (XEXP (addr, 0)) == REG)
        fprintf (file, "%s", reg_names[REGNO (addr)]);
      else abort();
      break;

    case REG:
      fprintf (file, "[%s]", reg_names[REGNO (addr)]);
      break;

    case PLUS:
      reg1 = 0;	reg2 = 0;
      ireg = 0;	breg = 0;
      offset = 0;
      if (GET_CODE (XEXP (addr, 0)) == REG)
	{
	  offset = XEXP (addr, 1);
	  addr = XEXP (addr, 0);
	}
      else if (GET_CODE (XEXP (addr, 1)) == REG)
	{
	  offset = XEXP (addr, 0);
	  addr = XEXP (addr, 1);
	}
      fprintf (file, "[%s]", reg_names[REGNO (addr)]);
      output_address (offset);
      break;

    default:
      output_addr_const (file, addr);
    }
}

static int
fcpu_ra_ever_killed ()
{
  rtx top;

#ifdef ASM_OUTPUT_MI_THUNK
  if (current_function_is_thunk)
    return 0;
#endif
  if (! fcpu_return_addr_rtx)
    return regs_ever_live[RETURN_VALUE_REGNUM];

  push_topmost_sequence ();
  top = get_insns ();
  pop_topmost_sequence ();

  return reg_set_between_p (gen_rtx_REG (Pmode, RETURN_VALUE_REGNUM), top, NULL_RTX);
}

int
fcpu_sa_size ()
{
  int sa_size = 0;
  int i;

#ifdef ASM_OUTPUT_MI_THUNK
  if (current_function_is_thunk)
    sa_size = 0;
  else
#endif
  {
     /* One for every register we have to save.  */
     for (i = 0; i < FIRST_PSEUDO_REGISTER; i++)
        if (! fixed_regs[i] && ! call_used_regs[i]
            && regs_ever_live[i] && i != RETURN_VALUE_REGNUM)
          sa_size++;
  }

  /* If some registers were saved but not RA, RA must also be saved,
     so leave space for it.  */
  if (sa_size != 0 || fcpu_ra_ever_killed ())
     sa_size++;

  /* Our size must be even (multiple of 16 bytes).  */
  if (sa_size & 1)
     sa_size++;

  return sa_size * 8;
}



