/*
 *
 *               THE GAMMA PROJECT
 *
 *   WHYGEE's ASSEMBLER: the syntactical analyser
 *
 *        " get ready for the headache ! "
 *
 *   Jan. 9 1999: cleaned up the GRAZER files
 *   Feb. 4 : modified some opcode fields
 *   Feb. 21: added the MOVE instruction
 *   Mar. 5 : transformed DATA into BYTE, WORD and DWORD, added ALIGN
 *            added better intra-space label resolution
 *   Mar. 8 : added OPLx and byte, word and dword cosntant lists
              with forward label references.
 *   Mar. 9 : NEW_LABEL EQU LABEL bug solved
 */

/*
 *  (known) bugs and problems to be aware of:
 *   - Very few over/underflow checks are made.
 *     beware of limitations with 32 bit machines !!!
 */

%token  EQU IP LABEL LABEL_REFERENCE NEW_LABEL NUMBER ORG PC
%token  ADDI MOVE MOVI MOVP SPACE PROPERTIES INDEX I D R SIZE NOP
%token  ADD ADDC BYTE WORD DWORD SERIALIZE ENDSTREAM CLR RDSPR
%token  WRSPR ALIGN OPL

/* for the expression evaluator */
%left '^'
%left '|'
%left '&'
%left ">>"
%left "<<"
%left '+'
%left '-'
%left '%'
%left '/'
%left '*'
%left '~'
%left NEG

%%     /* GRAMMAR RULES */

/* TOP LEVEL */
file:  /* nothing */

/* instruction: */
| file do_before_instruction ';'
{
  unsigned char * c = &instr_tab[current_space][instr_tab_offset[current_space]];
  /* BEWARE OF THE BYTE ORDER !!! */
  add(";");
  fprintf(list_output,"%04X:%02X%02X%02X%02X, l%03d: %s\n",
     Instruction_Pointer,c0,c1,c2,c3,parse_line,instruction_description);
  *instruction_description=0; /* reset the string */
  desc_size=0;
  *c=c0;
  *(c+1)=c1;
  *(c+2)=c2;
  *(c+3)=c3;
  instr_tab_offset[current_space]+=4;
  if (instr_tab_offset[current_space]>=MAX_INSTR*4)
    error ("too many instructions",NULL);
  Instruction_Pointer+=4;
}

  /* here are some "macros": */
| file LABEL
{
  referenced_label->value = Instruction_Pointer;
  referenced_label->space = current_space;
  resolve(referenced_label);
}

| file NEW_LABEL { referenced_label2=referenced_label; } EQU expr ';'
{
  referenced_label2->value = $4 ;
  referenced_label2->properties = LABEL_DECLARED ;
  referenced_label2->space = current_space;
  resolve(referenced_label2);
}

| file SIZE EQU expr ';'
{
  if ((($4 & -$4)!=$4) /* not a power of two */
     |(($4<8)|($4>32768))) /* bounds */
         error ("wrong word size",NULL);
  sizes[$2]=$4;
  fprintf(list_output,"Size #%d set to %d\n",$2,$4);
}

| file ORG expr ';' {
  Instruction_Pointer = $3;
  if (Instruction_Pointer & 3) warning ("ORG should be aligned in 4 byte boundary",NULL);
  fprintf(list_output,"Relocating the virtual instruction pointer to 0x%04X\n",
     Instruction_Pointer);
}

| file byte  bytelist ';'  { fprintf(list_output,"\n"); }
| file word  wordlist ';'  { fprintf(list_output,"\n"); }
| file dword dwordlist ';' { fprintf(list_output,"\n"); }
| file ALIGN expr ';' {
   int i,j;
   if (($3 & -$3)!=$3)
     error ("wrong align count",NULL);
   i=$3-1;
   j=~i;
   instr_tab_offset[current_space]=(instr_tab_offset[current_space]+i)& j;
   Instruction_Pointer=(Instruction_Pointer+i)& j;  /* round the pointers */
}

| file newspace ';'
;

byte:  BYTE  { fprintf(list_output,"%04X: l%03d: ",Instruction_Pointer,parse_line); }
word:  WORD  { fprintf(list_output,"%04X: l%03d: ",Instruction_Pointer,parse_line); }
dword: DWORD { fprintf(list_output,"%04X: l%03d: ",Instruction_Pointer,parse_line); }

bytelist:
  byte_item
| byte_item virg bytelist
;

wordlist:
  word_item
| word_item virg wordlist 
;

dwordlist:
  dword_item
| dword_item virg dwordlist 
;

newspace:
 SPACE expr prop index {
  current_space=$2;
  if (current_space>=MAXSPACE)
    error ("space number too big",NULL);
  if (instr_tab_offset[current_space]!=0)
      error ("space already defined",NULL);
  property[current_space]=$3;
  original_index[current_space]=Instruction_Pointer = $4;
  instr_tab_offset[current_space]=0;
  fprintf(list_output,"\n  space #%d\n",current_space);
}

prop: /* nothing */ { $$=EXECUTABLEREADWRITE; }
| PROPERTIES { $$=$1; }
;

index: /* nothing */ { $$=0; }
| INDEX expr  { $$=$2; }

/* CLEANUP */
do_before_instruction:
{
  instr_tab_offset[current_space]=(instr_tab_offset[current_space]+3)& ~3; /* round the pointers */
  Instruction_Pointer=(Instruction_Pointer+3)& ~3;
  parse_line=Line_Number;     /* prevents some incoherencies*/
  c0=c1=c2=c3=0;
}
instruction
;

/* THE BIG STUFF */
instruction:

/* form 1 : OPRI and the variants */
  op
| opr  size reg { c0=1; c1|= $3|128;  }
| opri size reg virg imm14 { c1|= $3; }
| movp r place virg imm16  { c1|= $2; }

/* form 2 : OP2R */
| op2r size reg virg reg   { c0|=32; c1|= $3; c2|=($5>>1); c3|=($5<<7); }

/* form 3 : OP3R */
| op3r size reg virg reg virg reg { c0|=64; c1|= $3; c2|=($5>>1); c3|=($5<<7)|$7; }

/* missing forms: JPF, LOOP, PFQ.... */

;

op: 
  NOP { add("NOP"); }
| SERIALIZE { add("SERIALIZE"); c3=1; }
| ENDSTREAM { add("ENDSTREAM"); c3=2; }
;

op2r:
MOVE { add ("MOVE"); }
;

opri:
  MOVI  { c1|=128;         add("MOVI"); }
| ADDI  { c0|=1;           add("ADDI"); }
| RDSPR { c0|=2; c1|=128;  add("RDSPR");}
| WRSPR { c0|=2;           add("WRSPR");}
;

movp:
  MOVP { c0|=4; add("MOVP ");  }
;

opr:
  CLR { add ("CLR"); }
;

op3r:
  OPL { SPRINTF("OPL%X",$1); c0|=$1>>1; c1|=$1<<7; }
;

/*
 destreg: reg { c1|= $1; } ;
 source1reg: reg { c2|=($1>>1); c3|=($1<<7); } ;
 source2reg: reg { c3|=$1; } ;
 */

reg:
  r { $$=$1;    }
| d { $$=$1+64; }
| i { $$=$1+96; }
;

r: R { $$=$1; SPRINTF("R%d",$1); } ;
d: D { $$=$1; SPRINTF("D%d",$1); } ;
i: I { $$=$1; SPRINTF("I%d",$1); } ;

 /*
   mult: '*' { add("*"); } ;
   open_par: '(' { add("("); } ;
   close_par: ')' { add(")"); } ;
   minus: '-' { add("-"); } ;
   plus: '+' { add("+"); } ;
   equal: '=' { add("="); } ;
  */

virg: ',' { add(", "); } ;
dot: '.' { add("."); } ;

size: dot expr {
  $$=$2;
  if ($2==sizes[0]) {/* nothing, already 0 */} else
    if ($2==sizes[1]) c2|=64; else
      if ($2==sizes[2]) c2|=128; else
        if ($2==sizes[3]) c2|=192; else
          error ("wrong register size",NULL);
      /* yeah i know it's ugly but what the heck ? */
  SPRINTF("%d ",$2);
}
| /* nothing: default to size3 */
  { c2|=192; SPRINTF(".%d ",sizes[3]);}
;

place: '[' expr ']' {
  int i=$2;
  if ((i<0)|(i>16)) error("wrong register place",NULL);
  SPRINTF("[%d]",i);
  c1|=i<<6;
  c0|=i>>2;
}
;

imm14: expr
{
  if (($1>8191)|($1<= -8192))
   error ("imm14 overflow",NULL);
  c2|=($1>>8) & 63;
  c3|=(unsigned char)$1;
  SPRINTF("0x%04X",$1);
}
| NEW_LABEL /*  this case is more delicate because we can't evaluate complex expressions */
{ /* this code adds a node to the relocation list */
  register struct undefined_node *p = mem_increase(sizeof(*p));
  p->next=referenced_label->undefined_list;
  p->where=instr_tab_offset[current_space];   /* before it is incremented */
  p->reloc_type=RELOC_imm14;
  p->space=current_space;
  referenced_label->undefined_list=p;
  add("{undefined}");
}
;

imm16: expr
{
  if (($1>32767)|($1<= -32768))
   error ("imm16 overflow",NULL);
  c2|=(unsigned char)($1>>8);
  c3|=(unsigned char)$1;
  SPRINTF("0x%04x",$1);
}
| NEW_LABEL
{
  register struct undefined_node *p = mem_increase(sizeof(*p));
  p->next=referenced_label->undefined_list;
  p->where=instr_tab_offset[current_space];   /* before it is incremented */
  p->reloc_type=RELOC_imm16;
  p->space=current_space;
  referenced_label->undefined_list=p;
  add("{undefined}");
}
;

byte_item: expr
{
  if (($1>127)|($1<= -128))
    error ("byte overflow",NULL);
  c0=(unsigned char)  $1;
  fprintf(list_output,"%02X ",c0);
  /* write the data to the buffer */
  instr_tab[current_space][instr_tab_offset[current_space]++]=c0;
  if (instr_tab_offset[current_space]>=MAX_INSTR*4)
    error ("too many instructions",NULL);
  Instruction_Pointer++;
}
| NEW_LABEL
{
  register struct undefined_node *p = mem_increase(sizeof(*p));
  p->next=referenced_label->undefined_list;
  p->where=instr_tab_offset[current_space];   /* before it is incremented */
  p->reloc_type=RELOC_byte;
  p->space=current_space;
  referenced_label->undefined_list=p;
  fprintf(list_output,"{} ");
  instr_tab_offset[current_space]++;
  Instruction_Pointer++;
}
;

word_item: expr
{
  if (($1>32767)|($1<= -32768))
    error ("word overflow",NULL);
  c0=(unsigned char)  $1;
  c1=(unsigned char)  $1>>8;
  fprintf(list_output,"%02X%02X ",c0,c1);
  /* write the data to the buffer */
  instr_tab[current_space][instr_tab_offset[current_space]++]=c0;
  instr_tab[current_space][instr_tab_offset[current_space]++]=c1;
  if (instr_tab_offset[current_space]>=MAX_INSTR*4)
    error ("too many instructions",NULL);
  Instruction_Pointer+=2;
}
| NEW_LABEL
{
  register struct undefined_node *p = mem_increase(sizeof(*p));
  p->next=referenced_label->undefined_list;
  p->where=instr_tab_offset[current_space];   /* before it is incremented */
  p->reloc_type=RELOC_word;
  p->space=current_space;
  referenced_label->undefined_list=p;
  fprintf(list_output,"{ud} ");
  instr_tab_offset[current_space]+=2;
  Instruction_Pointer+=2;
}
;

dword_item: expr
{
  c0=(unsigned char)  $1;
  c1=(unsigned char)  $1>>8;
  c0=(unsigned char)  $1>>16;
  c1=(unsigned char)  $1>>24;
  fprintf(list_output,"%02X%02X%02X%02X ",c0,c1,c2,c3);
  /* write the data to the buffer */
  instr_tab[current_space][instr_tab_offset[current_space]  ]=c0;
  instr_tab[current_space][instr_tab_offset[current_space]+1]=c1;
  instr_tab[current_space][instr_tab_offset[current_space]+2]=c0;
  instr_tab[current_space][instr_tab_offset[current_space]+3]=c1;
  instr_tab_offset[current_space]+=4;
  if (instr_tab_offset[current_space]>=MAX_INSTR*4)
    error ("too many instructions",NULL);
  Instruction_Pointer+=4;
}
| NEW_LABEL
{
  register struct undefined_node *p = mem_increase(sizeof(*p));
  p->next=referenced_label->undefined_list;
  p->where=instr_tab_offset[current_space];   /* before it is incremented */
  p->reloc_type=RELOC_dword;
  p->space=current_space;
  referenced_label->undefined_list=p;
  fprintf(list_output,"{undefd} ");
  instr_tab_offset[current_space]+=4;
  Instruction_Pointer+=4;
}
;

/* expression evaluator with arithmetic and boolean operations */
/* BEWARE: NO UNDER/OVERFLOW CHECK IS PERFORMED !!! */
expr: NUMBER  { $$ = yy_number;  }
    | LABEL_REFERENCE { $$ = referenced_label->value; }
    | IP { $$ = Instruction_Pointer; }
    | expr '^' expr  { $$ = $1 ^ $3; }
    | expr '|' expr  { $$ = $1 | $3; }
    | expr '&' expr  { $$ = $1 & $3; }
    | expr ">>" expr { $$ = $1 >> $3; }
    | expr "<<" expr { $$ = $1 << $3; }
    | expr '+' expr  { $$ = $1 + $3; }
    | expr '-' expr  { $$ = $1 - $3; }
    | expr '%' expr  { $$ = $1 % $3; }
    | expr '/' expr  { $$ = $1 / $3; }
    | expr '*' expr  { $$ = $1 * $3; }
    | '~' expr  { $$ = ~ $2; }
    | '-' expr %prec NEG { $$ = - $2; }
    | '(' expr ')'   { $$ = $2; }
    ;

%%
