#include <string.h>

#include "winutils.c"

/* X11 stuffs */
Window win_main;
Window button_quit; /*  10,10,45,17 */
Window button_init; /*  70,10,45,17 */
Window button_step; /* 125,10,45,17 */
Window button_mem;  /*  10,50,main_xsize-26, 50 */

Window button_LSU;       
Window button_LSU_tags;
Window button_fetch_logic;
Window button_fetcher_tags;
Window button_fetcher;

Window button_TLB;
Window button_decoder;

Window button_scoreboard;
Window button_registers;
Window button_SR;

Window button_Xbar;

XSegment main_segments[15];

Window win_mem;
Window button_hide_mem;
int hide_mem=HIDDEN;

int resize_flag=-1;
int t1,t2;


GC gc;
XEvent event;
KeySym keysym;
char car;

int main_xsize=600, main_ysize=600;  
int mem_xsize=500, mem_ysize=600;
int i;

void main(int argc, char **argv)
{

  /* read the init file here, eventually remember the window positions.... */

  /* init the simulation here */

  /* X11 */
  init_X();

redisplay:

  if (resize_flag & 1) {
    if (main_xsize<350) {
      main_xsize=350;
    }
    if (main_ysize<350) {
      main_ysize=350;
    }
    open_window(&win_main,main_xsize, main_ysize,&gc,black,grey,"MAIN WINDOW",SHOWN);
    open_daughter_window (&button_quit, win_main,  10, 10, 45, 17, &gc, black, light_grey, 1);
    open_daughter_window (&button_init, win_main,  70, 10, 45, 17, &gc, black, light_grey, 1);
    open_daughter_window (&button_step, win_main, 125, 10, 45, 17, &gc, black, light_grey, 1);
    open_daughter_window (&button_mem,  win_main,  10, 50,
        main_xsize-26, 50, &gc, black, light_grey, 3);
    
    t1=((main_xsize-20)/9);
    t2=((main_ysize-150)/5);

    open_daughter_window (&button_LSU, win_main,
                10, 130, (t1*3)-4, t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_LSU_tags, win_main,
         (t1*3)+10, 130, t1-4,     t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetch_logic, win_main,
         (t1*4)+10, 130, t1-4,     t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetcher_tags, win_main,
         (t1*5)+10, 130, t1-4,     t2-10, &gc, black, light_grey, 3);
    open_daughter_window (&button_fetcher, win_main,
         (t1*6)+10, 130, (t1*3)-4, t2-10, &gc, black, light_grey, 3);
    
    main_segments[0].x1=main_segments[0].x2=(t1*3)>>1;
    main_segments[1].x1=main_segments[1].x2=(t1*15)>>1;
    main_segments[0].y1=main_segments[1].y1=100;
    main_segments[0].y2=main_segments[1].y2=130;

    main_segments[6].y1=main_segments[7].y1=
    main_segments[2].y2=main_segments[3].y2=main_segments[4].y2=t2+120;
    main_segments[2].y1=main_segments[3].y1=main_segments[5].y1=main_segments[5].y2=t2+140;
    main_segments[6].y2=main_segments[7].y2=main_segments[4].y1=t2+160;
    main_segments[2].x1=main_segments[2].x2=main_segments[5].x1=(t1*7)>>1;
    main_segments[3].x1=main_segments[3].x2=(t1*11)>>1;
    main_segments[4].x1=main_segments[4].x2=main_segments[5].x2=(t1*15)>>1;

    main_segments[6].x1=main_segments[6].x2=main_segments[5].x1+12;
    main_segments[7].x1=main_segments[7].x2=main_segments[3].x1+12;
    
    open_daughter_window (&button_TLB, win_main,
        (((main_xsize-20)*3)>>3)+10, t2+160,
          ((main_xsize-20)>>2), t2-20, &gc, black, light_grey, 3);
    open_daughter_window (&button_decoder, win_main,
         (t1*6)+30, t2+160, (t1*3)-30, t2-10, &gc, black, light_grey, 3);
    
    open_daughter_window (&button_scoreboard, win_main,
         (t1*6)+30, (t2*2)+160, (t1*3)-30, t2-30, &gc, black, light_grey, 3);
    open_daughter_window (&button_registers, win_main,
         (t1*6)+30, (t2*3)+140, (t1*3)-30, t2+10, &gc, black, light_grey, 3);
    open_daughter_window (&button_SR, win_main,
         (t1*6)+30, (t2*4)+160, (t1*3)-30, t2-30, &gc, black, light_grey, 3);

    open_daughter_window (&button_Xbar, win_main,
         (t1*4)+20, (t2*2)+180, t1, (t2*3)-50, &gc, black, light_grey, 3);

    main_segments[8].x1=main_segments[8].x2=main_segments[9].x1=(t1*6)+10;
    main_segments[9].x2=(t1*5)+20;
    main_segments[8].y1=t2+140;
    main_segments[8].y2=main_segments[9].y1=main_segments[9].y2=(t2*2)+195;

    /* Xbar/R7 */
    for (i=1; i<6; i++) {
      main_segments[i+9].y1=main_segments[i+9].y2=((i*(t2+10))/6)+(t2*3)+140;
      main_segments[i+9].x1=(t1*5)+20;
      main_segments[i+9].x2=(t1*6)+30;
    }

  }

  if (resize_flag & 2) {
    if (mem_xsize<300) {
      mem_xsize=300;
    }
    if (mem_ysize<300) {
      mem_ysize=300;
    }
    open_window(&win_mem,mem_xsize, mem_ysize,&gc,black,grey,"MEMORY",hide_mem);
    open_daughter_window (&button_hide_mem, win_mem,  10, 10, 45, 17, &gc, black, light_grey, 1);
  }

  resize_flag=0;

  /* main loop */  

  do {
    XNextEvent(dpy,&event);
    switch(event.type) {

      case Expose:
        if (event.xexpose.window==button_quit){
          XDrawImageString(dpy,button_quit,gc,3,13,"QUIT",4);
	} else if (event.xexpose.window==button_init) {
          XDrawImageString(dpy,button_init,gc,5,13,"INIT",4);
	} else if (event.xexpose.window==button_step) {
          XDrawImageString(dpy,button_step,gc,3,13,"STEP",4);
	} else if (event.xexpose.window==button_hide_mem) {
          XDrawImageString(dpy,button_hide_mem,gc,3,13,"HIDE",4);
	} else if (event.xexpose.window==button_mem) {
          XDrawImageString(dpy,button_mem,gc,((main_xsize-(26*2))-52)>>1,(50+12)>>1,"MEMORY",6);
	} else if (event.xexpose.window==win_main) {
          XDrawSegments(dpy,win_main,gc,main_segments,15);
	} else if (event.xexpose.window==button_LSU) {
          XDrawImageString(dpy,button_LSU,gc,((t1*3)-30)>>1,t2>>1,"LSU",3);
	} else if (event.xexpose.window==button_LSU_tags) {
          XDrawImageString(dpy,button_LSU_tags,gc,((t1)-30)>>1,t2>>1,"tags",4);
	} else if (event.xexpose.window==button_fetch_logic) {
          XDrawImageString(dpy,button_fetch_logic,gc,((t1)-25)>>1,(t2>>1)-8,"Bus",3);
          XDrawImageString(dpy,button_fetch_logic,gc,((t1)-45)>>1,(t2>>1)+8,"Arbiter",7);
	} else if (event.xexpose.window==button_fetcher_tags) {
          XDrawImageString(dpy,button_fetcher_tags,gc,((t1)-30)>>1,t2>>1,"tags",4);
	} else if (event.xexpose.window==button_fetcher) {
          XDrawImageString(dpy,button_fetcher,gc,((t1*3)-70)>>1,t2>>1,"FETCHER",7);
	} else if (event.xexpose.window==button_Xbar) {
          XDrawImageString(dpy,button_Xbar,gc,(t1-30)>>1,((t2*3)>>1)-20,"Xbar",4);
	} else if (event.xexpose.window==button_TLB) {
          XDrawImageString(dpy,button_TLB,gc,(main_xsize>>3)-15,(t2>>1)-6,"TLB",3);
	} else if (event.xexpose.window==button_decoder) {
          XDrawImageString(dpy,button_decoder,gc,(main_xsize>>3)-25,t2>>1,"Decoder",7);
	} else if (event.xexpose.window==button_scoreboard) {
          XDrawImageString(dpy,button_scoreboard,gc,(main_xsize>>3)-35,(t2>>1)-10,"Scoreboard",10);
	} else if (event.xexpose.window==button_registers) {
          XDrawImageString(dpy,button_registers,gc,(main_xsize>>3)-45,(t2>>1)+10,"REGISTERS",9);
	} else if (event.xexpose.window==button_SR) {
          XDrawImageString(dpy,button_SR,gc,(main_xsize>>3)-50,(t2>>1)-10,
	      "Special Registers",21);
	}

        break;

      case ButtonPress:
	if ((event.xexpose.window==button_mem)
	  ||(event.xexpose.window==button_hide_mem)) {
          if (hide_mem==HIDDEN) {
            hide_mem=SHOWN;
            XMapWindow (dpy, win_mem);
	  }
	  else {
            hide_mem=HIDDEN;
            XUnmapWindow (dpy, win_mem);
	  }
	}

        break;

      case MotionNotify: /* pour d'eventuels scrollbars */

        break;

      case ResizeRequest:
        resize_flag=0;
        if (event.xresizerequest.window==win_main){
	  resize_flag=1;
          main_xsize=event.xresizerequest.width;
          main_ysize=event.xresizerequest.height;
	}
        else if (event.xresizerequest.window==win_mem) {
	  resize_flag=2;
          mem_xsize=event.xresizerequest.width;
          mem_ysize=event.xresizerequest.height;
	}

        break;

      case KeyPress :
        XLookupString(&event.xkey, &car, 1, &keysym, 0);
        if ((car=='q')||(car=='Q'))
          goto the_end;

        break;

    }
  } while (!(((event.type==ButtonRelease)&&(event.xexpose.window==button_quit))
            ||(resize_flag!=0)));

the_end:

  if (resize_flag==0) {
    /* collect the X geometries of the windows and save them to a file */
  }

  if ((resize_flag & 1)||(resize_flag==0)) {
    /*    close_window(&button_quit);
    close_window(&button_init);
    close_window(&button_step);
    close_window(&button_mem);
    close_window(&button_LSU);
    close_window(&button_LSU_tags);
    close_window(&button_fetch_logic);
    close_window(&button_fetcher_tags);
    close_window(&button_fetcher);
    close_window(&button_TLB);
    close_window(&button_decoder);
    close_window(&button_scoreboard);
    close_window(&button_registers);
    close_window(&button_SR);
    close_window(&button_Xbar);*/
    close_window(&win_main);

    if (resize_flag & 1) goto redisplay;
  }

  if ((resize_flag & 2)||(resize_flag==0)) {
    close_window(&button_hide_mem);
    close_window(&win_mem);
    if (resize_flag & 2) goto redisplay;
  }

  exitX();
}
