--------------------------------------------------------------------
-- F-CPU project : Instruction cache specification & testbench
-- created by Yann Guidon, oct. 3, 2000 (2am) with a lot of material
-- from the f-cpu@egroups.com mailing list (mostly Michael & Colin)
-- This file is not finished. GPL applies. Now you're warned.
--------------------------------------------------------------------

library IEEE;
    use IEEE.std_logic_1164.all;
    use IEEE.numeric_std.all;
    use std.textio.all;
    use ieee.std_logic_textio.all;

ENTITY  Icache_type  IS
  GENERIC(
    DBwidth  : natural := 256 ; -- Data Bus width, or width of each cache line (32 bytes)
    ABwidth  : natural := 32  ; -- Address Buss width, in 32-byte chuncks (32+5=128GB)
    LogLines : natural := 6   ; -- Log2 of the NumBer of cache Lines (MUST be EVEN)
    NBlines  : natural := 64    -- NumBer of cache Lines (2**LogLines) (small number for the first attempts)
  );
  PORT(
   Clk, Inv_En, Reset, Read_En, Write_En, Freeze_En : IN Boolean;
   Address_read, Address_write, Address_Mask : IN Std_ulogic_vector(ABwidth-1 downto 0);
-- "natural" should be used for the addresses, right ? But how do we handle
-- the AND with the masks ?
   Icache_hit : OUT Boolean;
   Din  :  IN Std_ulogic_vector(DBwidth-1 downto 0);
   Dout : OUT Std_ulogic_vector(DBwidth-1 downto 0)
  );
END Icache_type;

--------------------------------------------------------------------
-- Dumb latch with reset.
--------------------------------------------------------------------
Architecture dumb of Icache_type IS
begin
 process (CLK, reset)
     variable lout : line ;
 begin
   if reset=true then
     Dout<=(others=>'0');
--     WRITE(lout,"LATCH : Reset");
   else
     if (CLK'event and CLK=true) then
--       WRITE(lout,"LATCH : latching");
       Dout<=Din;
     end if;
   end if;
--   WRITELINE(OUTPUT, lout);
 end process;

end dumb;


--------------------------------------------------------------------
-- Testbenching :
--------------------------------------------------------------------
LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.std_logic_textio.all;
    USE ieee.numeric_std.all;
LIBRARY std;
    USE std.textio.ALL;
    USE work.Icache_type;

entity testbench is
-- copy of the above declaration
  GENERIC(
    DBwidth  : natural := 256 ; -- Data Bus width, or width of each cache line (32 bytes)
    ABwidth  : natural := 32  ; -- Address Buss width, in 32-byte chuncks (32+5=128GB)
    LogLines : natural := 6   ; -- Log2 of the NumBer of cache Lines (MUST be EVEN)
    NBlines  : natural := 64  ; -- NumBer of cache Lines (2**LogLines) (small number for the first attempts)

-- the line below is not copied :
    filename : string := "test3.txt"

  );
end testbench;

architecture test1 of testbench is
-- this is another copy, but here are the signals/ports :
  signal din,dout : Std_ulogic_vector(DBwidth-1 downto 0); -- uninitialized on purpose.
  signal reset,clk,Inv_En,Read_En,Write_En,Freeze_En : Boolean:=false; -- inputs of the cache
  signal Address_read, Address_write, Address_Mask : Std_ulogic_vector(ABwidth-1 downto 0):=(others=>'0');
  signal Icache_hit : Boolean; -- uninitialized : output signal;

-- internal counter :
  shared variable cycle : natural :=0;
  shared variable lout : line ;

  procedure print is
  begin
    WRITE(lout,"* cycle # : ");
    WRITE(lout,cycle);
    WRITE(lout,"   signals : ");
    if clk=true then
      WRITE(lout,"   clk");
    end if;
    if reset=true then
      WRITE(lout,"   reset");
    end if;
    if Icache_hit=true then
      WRITE(lout,"   Icache_hit ! Dout=");
      HWRITE(lout,Dout);
      WRITELINE(OUTPUT, lout);
    end if;
    if Read_En=true then
      WRITE(lout,"   Read_En:");
      HWRITE(lout,Address_read);
    end if;
    if Write_En=true then
      WRITE(lout,"   Write_En:");
      HWRITE(lout,Address_write);
      WRITE(lout," Din=");
      HWRITE(lout,Din);
      WRITELINE(OUTPUT, lout);
    end if;
    if Inv_En=true then
      WRITE(lout,"   Inv_En:");
      HWRITE(lout,Address_read);
      WRITE(lout,", address_mask:");
      HWRITE(lout,Address_Mask);
    end if;
    if Freeze_En=true then
      WRITE(lout,"   Freeze_En:");
      HWRITE(lout,Address_read);
      WRITE(lout,", address_mask:");
      HWRITE(lout,Address_Mask);
    end if;
    WRITELINE(OUTPUT, lout);
--    WRITE(lout," ");
--    WRITELINE(OUTPUT, lout);
  end;

-- For a dumb parser in VHDL :
  shared variable temp_char : Character := NUL;  -- parsed character
  shared variable buff : line;       -- line from which we parse
  shared variable line_number : natural:=0;
  shared variable i : natural;

  procedure getch is
  begin
    temp_char:=buff(i);
    i:=i+1;
  end;

  -- warning !!! no overflow checks !!!
  function get_hexa(s:Std_ulogic_vector) return Std_ulogic_vector is
    variable t:Std_ulogic_vector(3 downto 0):=(others=>'0');
    variable u:Std_ulogic_vector(s'high downto 0):=(others=>'0');
  begin
    hexa_loop : while i<=buff'high loop
      getch;
      case temp_char is
        when '0' => t:=X"0";
        when '1' => t:=X"1";
        when '2' => t:=X"2";
        when '3' => t:=X"3";
        when '4' => t:=X"4";
        when '5' => t:=X"5";
        when '6' => t:=X"6";
        when '7' => t:=X"7";
        when '8' => t:=X"8";
        when '9' => t:=X"9";
        when 'A' => t:=X"A";
        when 'B' => t:=X"B";
        when 'C' => t:=X"C";
        when 'D' => t:=X"D";
        when 'E' => t:=X"E";
        when 'F' => t:=X"F";
        when 'a' => t:=X"A";
        when 'b' => t:=X"B";
        when 'c' => t:=X"C";
        when 'd' => t:=X"D";
        when 'e' => t:=X"E";
        when 'f' => t:=X"F";
        when others => i:=i-1; return u;
      end case;
      u(u'high downto 4):=u((u'high)-4 downto 0);
      u(3 downto 0):=t;
    end loop;
-- this exit only if EOL :
    return u;
  end;

begin

 -- Instantiate the tested circuit
 Icache : entity Icache_type
   port map(
     Din => din,
     Dout => dout,
     clk => clk,
     reset => reset,
     Inv_En => Inv_En,
     Read_En => Read_En,
     Write_En => Write_En,
     Freeze_En => Freeze_En,
     Address_read => Address_read,
     Address_write => Address_write,
     Address_Mask => Address_Mask,
     Icache_hit => Icache_hit
   );

 process
   file test_vector : TEXT OPEN READ_MODE IS filename;
   variable temp_reset, temp_Inv_En, temp_Read_En, temp_Write_En, temp_Freeze_En : boolean;
 begin
-- init/reset :
   Din<=(others=>'0');
--   print;
   reset<=true;
   wait for 10 ns;
--   print;
   reset<=false;
   wait for 10 ns;
--   print;

-- begin the simulation body :
   while (not endfile(test_vector)) loop
     -- init temp inputs :
     temp_reset:=false;
     temp_Inv_En:=false;
     temp_Read_En:=false;
     temp_Write_En:=false;
     temp_Freeze_En:=false;

     -- read the parameters from the test vector file :
     readline(test_vector,buff);
     line_number:=line_number+1;
     write(lout,"*** decoding line #");
     write(lout,line_number);
     writeline(output,lout);

     If buff'length/=0 then

     -- parsing "buff" here ...
       i:=1;
parse_loop:
       while i<=buff'high loop
         getch;
         case temp_char is

           when ';' =>
             exit parse_loop;

           when 'Q' =>
             write(lout,LF&"   ### End of vector file ###."&LF);
             writeline(output,lout);
             wait;

           when 'T' =>
             if temp_reset=true then
               write(lout,"Warning : multiple Reset in vector !"&BEL);
             else
               temp_reset:=true;
             end if;

           when 'W' =>
             if temp_Write_En=true then
               write(lout,"Warning : multiple Writes in vector !"&BEL);
             else
               Address_write<=get_hexa(Address_write);
               i:=i+1; -- correct the index, restore the character that has been already "eaten"
               if temp_char/=':' then
                 report "expected ':' between address & data, not found";
               end if;
               Din<=get_hexa(Din);
               temp_Write_En:=true;
             end if;

           when 'R' =>
             if (temp_Freeze_En=true) or (temp_Read_En=true) or (temp_Inv_En=true) then
               write(lout,"Warning : multiple Reads/Invalidations/Freeze in vector !"&BEL);
             else
               Address_read<=get_hexa(Address_read);
               temp_Read_En:=true;
             end if;

           when 'I' =>
             if (temp_Freeze_En=true) or (temp_Inv_En=true) or (temp_Read_En=true)  then
               write(lout,"Warning : multiple Reads/Invalidations/Freeze in vector !"&BEL);
             else
               Address_read<=get_hexa(Address_read);
               i:=i+1; -- correct the index, restore the character that has been already "eaten"
               if temp_char/=':' then
                 report "expected ':' between address & mask, not found";
               end if;
               Address_Mask <=get_hexa(Address_Mask );
               temp_Inv_En:=true;
             end if;

           when 'F' =>
             if (temp_Freeze_En=true) or (temp_Inv_En=true) or (temp_Read_En=true)  then
               write(lout,"Warning : multiple Reads/Invalidations/Freeze in vector !"&BEL);
             else
               Address_read<=get_hexa(Address_read);
               i:=i+1; -- correct the index, restore the character that has been already "eaten"
               if temp_char/=':' then
                 report "expected ':' between address & mask, not found";
               end if;
               Address_Mask <=get_hexa(Address_Mask );
               temp_Freeze_En:=true;
             end if;

           when others =>
             write(lout,LF&"  # unknown command : ");
             write(lout,temp_char&LF);

         end case;
         writeline(output,lout);
  
-- expect a coma/separator/EOL :
         if (i-1>=buff'High) then   -- do not expect coma if already at end of line
           exit parse_loop;
         end if;
         getch;
         if (temp_char = ';') then
           exit parse_loop;
         end if;
         if (temp_char /= ',') then
           write(lout,"',' expected, got ");
           write(lout,temp_char);
           write(lout," instead");
           writeline(output,lout);
         end if;

       end loop parse_loop;
--     else
--       report "skipping empty line";
     end if; -- void string

     reset<=temp_reset;
     Inv_En<=temp_Inv_En;
     Read_En<=temp_Read_En;
     Write_En<=temp_Write_En;
     Freeze_En<=temp_Freeze_En;

     -- cycle :
     clk<=true;        -- rising edge
     cycle:=cycle+1;   -- advance the counter
     wait for 10 ns;   -- let the circuit do the work
     clk<=false;       -- falling edge
     wait for 10 ns;   -- leave some time to react
     print;            -- be happy
   end loop;

   file_close(test_vector);

   wait; -- stop the simulation
 end process;

end test1;
